using UnityEngine.SceneManagement;
using UnityEngine;
using System.Collections.Generic;

public class DontDestroyOnLoadScene : MonoBehaviour {

 
    public List<GameObject> objects = new List<GameObject>();

    //pour creer une instance de gameovermanager
    public static DontDestroyOnLoadScene instance;
    private void Awake()
    {
        if (instance != null)
        {
            Debug.LogWarning("plus d'une d'instance DontDestroyOnLoadScene");
            return;
        }

        instance = this;

        foreach (var element in objects)
        {
            DontDestroyOnLoad(element);
        }

       
    }
   
    public void RemoveFromDontDestroyOnLoad()
    {
        foreach(var element in objects)
        {
            SceneManager.MoveGameObjectToScene(element, SceneManager.GetActiveScene());
        }
    }

}