using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class EnemyMovement : MonoBehaviour {

    public float speed;
    public Transform[] waypoints;

    public SpriteRenderer graphics;
    private Transform target;
    private int destPoint;
    public Animator animator;

    public static EnemyMovement instance;

    public int enemyDamageOnCollision = 20;

    private void Awake () {
        if (instance != null) {
            Debug.Log ("il n'y a plus d'instance de EnemyMovement dans la scène");
            return;
        }

        instance = this;
    }

    // Start is called before the first frame update
    void Start () {
        target = waypoints[0];
    }

    // Update is called once per frame
    void Update () {
        Vector3 dir = target.position - transform.position;
        transform.Translate (dir.normalized * speed * Time.deltaTime, Space.World);

        // Si l'ennemi est presque arrivé à sa destination
        if (Vector3.Distance (transform.position, target.position) < 0.3f) {
            destPoint = (destPoint + 1) % waypoints.Length;
            target = waypoints[destPoint];
            graphics.flipX = !graphics.flipX;
        }

    }

    private void OnCollisionEnter2D(Collision2D collision)
    {
        if (collision.transform.CompareTag("Player"))
        {
            PlayerHealth playerHealth = collision.transform.GetComponent<PlayerHealth>();
            playerHealth.TakeDamage(enemyDamageOnCollision);
        }
    }
}