//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------
using NUnit.Framework;
using static Unity.Mathematics.math;
using Burst.Compiler.IL.Tests;

namespace Unity.Mathematics.Tests
{
    [TestFixture]
    public class TestDouble2x3
    {
        [TestCompiler]
        public static void double2x3_zero()
        {
            TestUtils.AreEqual(double2x3.zero.c0.x, 0.0);
            TestUtils.AreEqual(double2x3.zero.c0.y, 0.0);
            TestUtils.AreEqual(double2x3.zero.c1.x, 0.0);
            TestUtils.AreEqual(double2x3.zero.c1.y, 0.0);
            TestUtils.AreEqual(double2x3.zero.c2.x, 0.0);
            TestUtils.AreEqual(double2x3.zero.c2.y, 0.0);
        }

        [TestCompiler]
        public static void double2x3_operator_equal_wide_wide()
        {
            double2x3 a0 = double2x3(-135.18925172425304, -49.094127439471947, 169.12980778940482, 240.80529772527757, 314.73919382446411, 442.39301916695808);
            double2x3 b0 = double2x3(-220.01464591734793, 66.980020792679852, 499.20158576369363, -371.113114291389, 208.44865212610398, 390.80369133074009);
            bool2x3 r0 = bool2x3(false, false, false, false, false, false);
            TestUtils.AreEqual(a0 == b0, r0);

            double2x3 a1 = double2x3(177.92444881141398, 335.53340283759564, 168.1544516869609, 350.72955982327903, 367.17843668869625, 46.941470406456574);
            double2x3 b1 = double2x3(-72.443806920407269, 362.97643273089841, 194.6783255053117, 471.6448635867074, -404.04466719368691, -144.69675476136467);
            bool2x3 r1 = bool2x3(false, false, false, false, false, false);
            TestUtils.AreEqual(a1 == b1, r1);

            double2x3 a2 = double2x3(188.76415094582558, -97.211392209497944, -293.3210057193977, -234.82292353120766, 417.03371329653714, 26.386443388828297);
            double2x3 b2 = double2x3(-494.44664334433463, -252.97038209297244, 234.41711746641306, 398.72397465199413, 260.42872083393331, 370.14420502732708);
            bool2x3 r2 = bool2x3(false, false, false, false, false, false);
            TestUtils.AreEqual(a2 == b2, r2);

            double2x3 a3 = double2x3(269.24572265764959, 29.474191440955792, 479.48521469509467, -237.23094355186026, -221.98371349181224, -506.67253255596034);
            double2x3 b3 = double2x3(89.579862397899774, -434.81684347373289, -109.84533815730612, 336.9730161805511, -409.15498156526826, 500.38755273278218);
            bool2x3 r3 = bool2x3(false, false, false, false, false, false);
            TestUtils.AreEqual(a3 == b3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_equal_wide_scalar()
        {
            double2x3 a0 = double2x3(65.671194345537174, 404.41550440546848, -269.7301577393572, 83.630607882342588, 152.99450476141385, -155.86829836474186);
            double b0 = (-155.8157547245807);
            bool2x3 r0 = bool2x3(false, false, false, false, false, false);
            TestUtils.AreEqual(a0 == b0, r0);

            double2x3 a1 = double2x3(314.67125597348024, 290.04894007837811, -132.63519460178691, -65.667489797653388, -69.683271678948415, -191.19075521789063);
            double b1 = (386.36515325417986);
            bool2x3 r1 = bool2x3(false, false, false, false, false, false);
            TestUtils.AreEqual(a1 == b1, r1);

            double2x3 a2 = double2x3(186.84520086406042, -319.14406481345372, -49.701092981594172, -300.88189925853248, 333.39685193328046, 386.377503336583);
            double b2 = (-232.89569221851218);
            bool2x3 r2 = bool2x3(false, false, false, false, false, false);
            TestUtils.AreEqual(a2 == b2, r2);

            double2x3 a3 = double2x3(-296.70189084517858, 141.54237968360189, -227.32334314441465, 83.872881689981, -410.91687483848858, 110.50128345866744);
            double b3 = (-309.11719741910565);
            bool2x3 r3 = bool2x3(false, false, false, false, false, false);
            TestUtils.AreEqual(a3 == b3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_equal_scalar_wide()
        {
            double a0 = (36.383921878591195);
            double2x3 b0 = double2x3(-400.48919958644046, -71.286823544319191, 156.97811491646712, -225.23872791288363, 499.14180993435059, -211.97992358542047);
            bool2x3 r0 = bool2x3(false, false, false, false, false, false);
            TestUtils.AreEqual(a0 == b0, r0);

            double a1 = (428.31192394174263);
            double2x3 b1 = double2x3(-489.50133322621758, -5.6915457275190988, -30.865948453017495, -362.98307221149241, 184.50319322594589, -160.47062142215231);
            bool2x3 r1 = bool2x3(false, false, false, false, false, false);
            TestUtils.AreEqual(a1 == b1, r1);

            double a2 = (316.66882315122928);
            double2x3 b2 = double2x3(390.36923879681581, 505.10510301268891, -294.64870967280524, 443.19909283295226, 96.559236333034619, -257.01294601010761);
            bool2x3 r2 = bool2x3(false, false, false, false, false, false);
            TestUtils.AreEqual(a2 == b2, r2);

            double a3 = (-245.05497538533757);
            double2x3 b3 = double2x3(326.46485176983515, -23.959890138339176, -168.6948808025079, 386.24859279498855, -227.09065185631192, -336.61242524562982);
            bool2x3 r3 = bool2x3(false, false, false, false, false, false);
            TestUtils.AreEqual(a3 == b3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_not_equal_wide_wide()
        {
            double2x3 a0 = double2x3(279.99414576217259, -43.342018386042696, -465.72473523846116, 317.46655645848557, 85.714987079480238, 360.89050572034466);
            double2x3 b0 = double2x3(-460.912120318465, -476.00904844515446, 468.13642070635058, -341.01254312182431, -62.658060341448561, -458.80166718866752);
            bool2x3 r0 = bool2x3(true, true, true, true, true, true);
            TestUtils.AreEqual(a0 != b0, r0);

            double2x3 a1 = double2x3(366.08152668833804, 154.5428384070018, 332.426219856565, 397.11323160543725, -431.3749584776233, 489.01079319837072);
            double2x3 b1 = double2x3(-457.73023316717251, -59.523265627922171, 3.024243117787023, 155.81276352508587, -19.839918384253963, -6.0169332055453992);
            bool2x3 r1 = bool2x3(true, true, true, true, true, true);
            TestUtils.AreEqual(a1 != b1, r1);

            double2x3 a2 = double2x3(398.43358320669904, -489.81794594685454, 171.4049242340983, -67.829682620162941, -192.27871498478515, 227.84082494854965);
            double2x3 b2 = double2x3(-406.20792145571107, -102.42070083619126, -40.362921018322425, 452.67542645552919, 93.257571979080126, -258.37806689849964);
            bool2x3 r2 = bool2x3(true, true, true, true, true, true);
            TestUtils.AreEqual(a2 != b2, r2);

            double2x3 a3 = double2x3(62.138187675801191, 262.18648755838467, -404.05309052209049, 34.449567572423007, -204.79578719138902, -285.41180314003111);
            double2x3 b3 = double2x3(-184.04980405794913, -379.23531192319251, -370.68729537105526, -255.94724023339677, 29.055771602809273, 322.40763226263584);
            bool2x3 r3 = bool2x3(true, true, true, true, true, true);
            TestUtils.AreEqual(a3 != b3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_not_equal_wide_scalar()
        {
            double2x3 a0 = double2x3(-155.44111282911206, -19.426602134214079, 174.63305409934048, 507.9207296352464, 59.177048472304364, 171.15146430356026);
            double b0 = (-393.41354173860213);
            bool2x3 r0 = bool2x3(true, true, true, true, true, true);
            TestUtils.AreEqual(a0 != b0, r0);

            double2x3 a1 = double2x3(-58.923273352404692, 492.20105361016522, -165.24150879925185, 270.34102333259818, -380.24326222960059, 501.8990516615562);
            double b1 = (-398.17684835855704);
            bool2x3 r1 = bool2x3(true, true, true, true, true, true);
            TestUtils.AreEqual(a1 != b1, r1);

            double2x3 a2 = double2x3(-134.34545642433011, 46.771004937016869, 161.45995123752391, 261.51423442620512, -145.61239559278471, -0.44992661497087738);
            double b2 = (458.40042302496749);
            bool2x3 r2 = bool2x3(true, true, true, true, true, true);
            TestUtils.AreEqual(a2 != b2, r2);

            double2x3 a3 = double2x3(350.46143047439932, 242.66402232025939, 382.67707675633812, -468.96794221781562, -497.45947789468778, -80.932258882062627);
            double b3 = (202.22103724359579);
            bool2x3 r3 = bool2x3(true, true, true, true, true, true);
            TestUtils.AreEqual(a3 != b3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_not_equal_scalar_wide()
        {
            double a0 = (478.35313938481409);
            double2x3 b0 = double2x3(459.55319592894671, 436.45324369727314, -488.71416806090349, 392.76794475725296, -266.73665369056937, 338.55788270503183);
            bool2x3 r0 = bool2x3(true, true, true, true, true, true);
            TestUtils.AreEqual(a0 != b0, r0);

            double a1 = (-338.10012475498957);
            double2x3 b1 = double2x3(-152.3145445102428, -452.82067868338, 209.43931422449612, 50.107968592135194, 372.4343656843688, -488.0213141329686);
            bool2x3 r1 = bool2x3(true, true, true, true, true, true);
            TestUtils.AreEqual(a1 != b1, r1);

            double a2 = (489.74075697816011);
            double2x3 b2 = double2x3(270.40006149485714, -472.8467831429312, -286.85046090132113, -384.69186681541237, 443.42352959300558, 358.74720900074919);
            bool2x3 r2 = bool2x3(true, true, true, true, true, true);
            TestUtils.AreEqual(a2 != b2, r2);

            double a3 = (-15.414077527548216);
            double2x3 b3 = double2x3(-342.17916194637269, 468.96750400446706, -130.56808501601597, 401.7858013593526, -268.35225761511936, -239.231014124691);
            bool2x3 r3 = bool2x3(true, true, true, true, true, true);
            TestUtils.AreEqual(a3 != b3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_less_wide_wide()
        {
            double2x3 a0 = double2x3(51.710243010758518, -313.85556450200062, 283.04767359562572, 235.02188621974642, 44.0783565249659, -207.25566659088042);
            double2x3 b0 = double2x3(-261.83523881707117, -19.810742149041403, -149.25882084167506, 205.99822316225539, -306.02438535635565, 102.12168006884008);
            bool2x3 r0 = bool2x3(false, true, false, false, false, true);
            TestUtils.AreEqual(a0 < b0, r0);

            double2x3 a1 = double2x3(3.3829410091894943, -144.30134326978651, -69.369597705718888, -135.66796762108243, -194.78736576567746, -33.473868147225062);
            double2x3 b1 = double2x3(231.90633760760829, 179.49885305180158, 473.22488496882136, 15.891647107848712, 270.04990614114786, 490.91400240869916);
            bool2x3 r1 = bool2x3(true, true, true, true, true, true);
            TestUtils.AreEqual(a1 < b1, r1);

            double2x3 a2 = double2x3(-19.675088653189619, 423.23796697297973, -71.698315415390937, -501.88598870760109, 7.6438391244242894, 302.26289214857991);
            double2x3 b2 = double2x3(-185.73412164753961, 76.433086669274189, 97.75231246731812, 419.30080600236579, 73.953208242521214, 481.03232382285978);
            bool2x3 r2 = bool2x3(false, false, true, true, true, true);
            TestUtils.AreEqual(a2 < b2, r2);

            double2x3 a3 = double2x3(-140.55051786291904, -436.586703265359, -351.441728040316, 364.97084896870467, 301.894133946809, 407.55097336673691);
            double2x3 b3 = double2x3(7.00747371046225, -7.3240954910051528, -413.07575793428146, -154.1188920261892, 449.20288989003882, 502.01430797111914);
            bool2x3 r3 = bool2x3(true, true, false, false, true, true);
            TestUtils.AreEqual(a3 < b3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_less_wide_scalar()
        {
            double2x3 a0 = double2x3(-221.86977325280651, -121.54646807608498, -97.52392511140738, 479.88107775146193, 67.118990214131259, 137.32880574899207);
            double b0 = (199.06751808853244);
            bool2x3 r0 = bool2x3(true, true, true, false, true, true);
            TestUtils.AreEqual(a0 < b0, r0);

            double2x3 a1 = double2x3(282.96659601990439, -111.41316061439608, -288.08113278452356, 82.665427008022334, -361.64292042406413, -68.088202269788951);
            double b1 = (258.27909362422258);
            bool2x3 r1 = bool2x3(false, true, true, true, true, true);
            TestUtils.AreEqual(a1 < b1, r1);

            double2x3 a2 = double2x3(12.788020378345664, -78.762971199472872, 25.727694284975428, 101.37087182950734, -330.442660724019, -48.920521520506838);
            double b2 = (-66.703050406045747);
            bool2x3 r2 = bool2x3(false, true, false, false, true, false);
            TestUtils.AreEqual(a2 < b2, r2);

            double2x3 a3 = double2x3(359.60440914686978, 241.27682101040932, -183.43778165776178, 423.02713580756779, -334.62272349680904, -98.315578744893685);
            double b3 = (-8.15008759878117);
            bool2x3 r3 = bool2x3(false, false, true, false, true, true);
            TestUtils.AreEqual(a3 < b3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_less_scalar_wide()
        {
            double a0 = (-250.4849370692321);
            double2x3 b0 = double2x3(-377.19654887597846, -505.14754104295167, 375.92672198634909, 110.17393474940855, -118.09757452742082, -40.45089079833167);
            bool2x3 r0 = bool2x3(false, false, true, true, true, true);
            TestUtils.AreEqual(a0 < b0, r0);

            double a1 = (-299.74430932651478);
            double2x3 b1 = double2x3(31.437125935888389, -458.904539560389, 13.684679276163024, -458.50690839183841, 248.27646624682302, 389.23142999654237);
            bool2x3 r1 = bool2x3(true, false, true, false, true, true);
            TestUtils.AreEqual(a1 < b1, r1);

            double a2 = (488.74553679337055);
            double2x3 b2 = double2x3(-221.63786731550368, -424.26720329013989, 249.05904948388184, -22.136127720650336, -442.24773928255206, -340.85755721705851);
            bool2x3 r2 = bool2x3(false, false, false, false, false, false);
            TestUtils.AreEqual(a2 < b2, r2);

            double a3 = (-95.1117256130612);
            double2x3 b3 = double2x3(15.409410245441563, 87.292497437117845, 495.06764220402931, 316.01850309782594, -125.56811505442863, 122.16476803746298);
            bool2x3 r3 = bool2x3(true, true, true, true, false, true);
            TestUtils.AreEqual(a3 < b3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_greater_wide_wide()
        {
            double2x3 a0 = double2x3(-229.29066501804192, 505.536608216137, -73.80706862071861, 100.29203777215071, -419.21478124112582, -159.55974753180504);
            double2x3 b0 = double2x3(-445.84502407808088, -420.03529210576568, 299.02440108872224, -13.880978829171966, 151.56173593903043, -163.5094302461992);
            bool2x3 r0 = bool2x3(true, true, false, true, false, true);
            TestUtils.AreEqual(a0 > b0, r0);

            double2x3 a1 = double2x3(-396.7703608929973, 127.03739482119556, 489.13989733585151, 51.91890885863404, 155.38475544535777, -135.63165027258526);
            double2x3 b1 = double2x3(-391.09603733154762, 479.2837710228207, -77.674873149802409, -46.5841996886694, -415.37701888353422, 71.466978344818131);
            bool2x3 r1 = bool2x3(false, false, true, true, true, false);
            TestUtils.AreEqual(a1 > b1, r1);

            double2x3 a2 = double2x3(-425.97813554572787, -228.430505143679, 383.03834909155887, 136.53358298937496, 8.602427725029429, -251.3243674018068);
            double2x3 b2 = double2x3(-206.06102643071722, 360.83628218287424, 236.96878658838978, 14.550342328171382, 364.735178402036, -159.0612996365229);
            bool2x3 r2 = bool2x3(false, false, true, true, false, false);
            TestUtils.AreEqual(a2 > b2, r2);

            double2x3 a3 = double2x3(-345.954920691417, -170.565928777012, -293.25441588706076, 139.1249764613458, 214.3030732675935, 238.76991211565678);
            double2x3 b3 = double2x3(226.63117490831348, 182.79602512288659, 341.83937398616195, -79.130463875425278, -247.29681956362765, 164.58913882290437);
            bool2x3 r3 = bool2x3(false, false, false, true, true, true);
            TestUtils.AreEqual(a3 > b3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_greater_wide_scalar()
        {
            double2x3 a0 = double2x3(11.156317000815761, -411.02322382993214, 385.88556188432756, -485.10304831206008, -491.18003033622171, 405.17534632476759);
            double b0 = (-302.81693877969724);
            bool2x3 r0 = bool2x3(true, false, true, false, false, true);
            TestUtils.AreEqual(a0 > b0, r0);

            double2x3 a1 = double2x3(173.57509740329124, 501.30683183172107, -367.027771405423, -86.124509613087639, -489.09058998948456, -172.51816066192379);
            double b1 = (69.269281181166548);
            bool2x3 r1 = bool2x3(true, true, false, false, false, false);
            TestUtils.AreEqual(a1 > b1, r1);

            double2x3 a2 = double2x3(-18.149639853346002, -238.8945134798505, -27.239137900638923, 471.77934072528933, 240.16453253485474, -481.47807930478734);
            double b2 = (-236.41493498367021);
            bool2x3 r2 = bool2x3(true, false, true, true, true, false);
            TestUtils.AreEqual(a2 > b2, r2);

            double2x3 a3 = double2x3(185.59438547193747, -510.22814702905163, -183.28619607877278, -386.12766260007754, -13.638212448748845, -7.3478887115362568);
            double b3 = (33.294723764664809);
            bool2x3 r3 = bool2x3(true, false, false, false, false, false);
            TestUtils.AreEqual(a3 > b3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_greater_scalar_wide()
        {
            double a0 = (453.54610201974685);
            double2x3 b0 = double2x3(-226.20441423459187, -423.46500487973213, 409.40550227156166, 453.87706277048073, 87.475727837288673, 113.79560308987072);
            bool2x3 r0 = bool2x3(true, true, true, false, true, true);
            TestUtils.AreEqual(a0 > b0, r0);

            double a1 = (176.40926154721956);
            double2x3 b1 = double2x3(-140.44002944810319, -182.48286804113673, -158.29329188088576, -162.68531830733889, -193.328676075362, 230.18129955519987);
            bool2x3 r1 = bool2x3(true, true, true, true, true, false);
            TestUtils.AreEqual(a1 > b1, r1);

            double a2 = (-102.58784227379965);
            double2x3 b2 = double2x3(392.5205878655056, -177.47865947404813, -10.295010809924008, -24.048938524000789, 172.44867499752377, 374.04800503982608);
            bool2x3 r2 = bool2x3(false, true, false, false, false, false);
            TestUtils.AreEqual(a2 > b2, r2);

            double a3 = (-368.99763958947619);
            double2x3 b3 = double2x3(-210.19528804076617, 149.47022325800276, -281.34327019441093, -100.46916608720511, 304.86444320569956, -361.52483360912879);
            bool2x3 r3 = bool2x3(false, false, false, false, false, false);
            TestUtils.AreEqual(a3 > b3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_less_equal_wide_wide()
        {
            double2x3 a0 = double2x3(240.09053169940159, 462.2131528622532, 293.08251561461134, -427.87067361728782, -405.5227226715175, 204.59190211286386);
            double2x3 b0 = double2x3(-81.203838624620744, 493.63743876555816, -411.47211451617636, 99.164449499530974, -295.66769875943089, -480.46254824123463);
            bool2x3 r0 = bool2x3(false, true, false, true, true, false);
            TestUtils.AreEqual(a0 <= b0, r0);

            double2x3 a1 = double2x3(294.670105832941, -327.56444445604666, -456.12326667091031, 282.3012408140587, 421.8811549720732, -311.71284809322697);
            double2x3 b1 = double2x3(74.414040361723892, 260.916124226952, 306.17329730939741, 139.56480438055689, -505.75247955031341, -489.62680958659706);
            bool2x3 r1 = bool2x3(false, true, true, false, false, false);
            TestUtils.AreEqual(a1 <= b1, r1);

            double2x3 a2 = double2x3(84.5674827492644, 447.24461647832982, -154.49435217422172, -424.36474986763892, 36.684489505684269, 267.07029283562224);
            double2x3 b2 = double2x3(-280.03260267899958, 303.15991058161478, 511.19015788994272, -104.65973358259527, 95.1465771641333, -125.6363432992419);
            bool2x3 r2 = bool2x3(false, false, true, true, true, false);
            TestUtils.AreEqual(a2 <= b2, r2);

            double2x3 a3 = double2x3(307.89391937288167, -351.76015369582927, -157.36036570247279, 152.70902712303632, 372.26716750313858, 202.36828837281485);
            double2x3 b3 = double2x3(376.239777024947, -415.7747320680761, -47.481050275024529, 117.72210293529656, 469.37837264937275, -263.04235780567041);
            bool2x3 r3 = bool2x3(true, false, true, false, true, false);
            TestUtils.AreEqual(a3 <= b3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_less_equal_wide_scalar()
        {
            double2x3 a0 = double2x3(309.1924356469849, 69.673792633076118, -101.72418622939114, -315.97240629604664, -346.01106731314724, 424.15386577330241);
            double b0 = (292.92427148154206);
            bool2x3 r0 = bool2x3(false, true, true, true, true, false);
            TestUtils.AreEqual(a0 <= b0, r0);

            double2x3 a1 = double2x3(-410.87006945669191, 183.82114538169515, 320.44249287268258, -257.87003791419329, -386.801748694294, -182.9388249772316);
            double b1 = (-483.90265320423185);
            bool2x3 r1 = bool2x3(false, false, false, false, false, false);
            TestUtils.AreEqual(a1 <= b1, r1);

            double2x3 a2 = double2x3(349.25012962392077, 373.56911652794531, 259.15151822713744, 450.13007828692446, -128.5255282523695, -43.874866744445114);
            double b2 = (485.31159304329731);
            bool2x3 r2 = bool2x3(true, true, true, true, true, true);
            TestUtils.AreEqual(a2 <= b2, r2);

            double2x3 a3 = double2x3(457.38574549992836, 479.45184038553941, -499.51644372358754, -398.13294643821797, 402.48485893871862, 87.9161055497434);
            double b3 = (-77.638293064030961);
            bool2x3 r3 = bool2x3(false, false, true, true, false, false);
            TestUtils.AreEqual(a3 <= b3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_less_equal_scalar_wide()
        {
            double a0 = (-511.15238141974078);
            double2x3 b0 = double2x3(51.159012579898786, 340.44369022010062, 312.81429519914752, 354.19252626699983, 136.39671165142056, -94.767871185563422);
            bool2x3 r0 = bool2x3(true, true, true, true, true, true);
            TestUtils.AreEqual(a0 <= b0, r0);

            double a1 = (288.544332877055);
            double2x3 b1 = double2x3(304.04282369466625, -148.61806089646092, -506.30010127755816, 27.581254256694251, 48.471146844546865, 104.88351326104419);
            bool2x3 r1 = bool2x3(true, false, false, false, false, false);
            TestUtils.AreEqual(a1 <= b1, r1);

            double a2 = (-488.6858386884843);
            double2x3 b2 = double2x3(-480.43516968210935, 421.9366516647566, 239.72105299668431, -101.01844673092404, -283.95147551407638, -55.2435333986038);
            bool2x3 r2 = bool2x3(true, true, true, true, true, true);
            TestUtils.AreEqual(a2 <= b2, r2);

            double a3 = (-455.80483147865385);
            double2x3 b3 = double2x3(131.10721618081777, -461.69878099006542, -388.48285001725094, -258.93605125087129, -225.2235287284588, -116.01998215355911);
            bool2x3 r3 = bool2x3(true, false, true, true, true, true);
            TestUtils.AreEqual(a3 <= b3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_greater_equal_wide_wide()
        {
            double2x3 a0 = double2x3(-386.59181302906563, -157.12078221008215, 391.01526445477054, -511.88687133783793, -5.4220387960886569, 287.64527501149348);
            double2x3 b0 = double2x3(153.44301350109424, 49.892483019219981, 78.025787628267835, 138.81373292711271, -225.51057802211056, -339.35611335344436);
            bool2x3 r0 = bool2x3(false, false, true, false, true, true);
            TestUtils.AreEqual(a0 >= b0, r0);

            double2x3 a1 = double2x3(-122.53520184500849, 7.4814426933794493, 152.94642765491574, 48.986223482054811, 57.338148859021317, 300.46493138953338);
            double2x3 b1 = double2x3(-373.302078182484, 364.9358934671319, -322.71539870030961, 125.47818165900105, -25.776589167200314, 297.51890792395864);
            bool2x3 r1 = bool2x3(true, false, true, false, true, true);
            TestUtils.AreEqual(a1 >= b1, r1);

            double2x3 a2 = double2x3(349.25705139211243, 85.749700824613569, -230.95330654408468, 418.7112159294594, -131.03991824530061, -126.51221257378916);
            double2x3 b2 = double2x3(73.222349439385539, 462.78374288174496, 393.19134515951919, -95.001432224643168, 381.35702556248611, 93.031928344178937);
            bool2x3 r2 = bool2x3(true, false, false, true, false, false);
            TestUtils.AreEqual(a2 >= b2, r2);

            double2x3 a3 = double2x3(-156.81847841889527, 422.37748761772059, -413.08933348818186, 219.44273553576443, 35.591133372667741, 447.18153521380464);
            double2x3 b3 = double2x3(254.25326287665087, 90.672789377473691, 348.93816892660141, 161.33763106229605, 79.435611046587837, 420.24346824187944);
            bool2x3 r3 = bool2x3(false, true, false, true, false, true);
            TestUtils.AreEqual(a3 >= b3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_greater_equal_wide_scalar()
        {
            double2x3 a0 = double2x3(495.457423679278, -14.345115906719627, -463.47478053694346, 217.51749215718246, -246.86571776441565, -377.65869706573835);
            double b0 = (189.20512804258851);
            bool2x3 r0 = bool2x3(true, false, false, true, false, false);
            TestUtils.AreEqual(a0 >= b0, r0);

            double2x3 a1 = double2x3(53.815095211293169, -221.50546441856096, 252.99433410027734, -116.44038277326172, -395.36331028275345, 164.77259667439978);
            double b1 = (-123.33294373533357);
            bool2x3 r1 = bool2x3(true, false, true, true, false, true);
            TestUtils.AreEqual(a1 >= b1, r1);

            double2x3 a2 = double2x3(-287.00733889593153, 184.19556316369938, 273.01225555735277, -418.14240308205706, 249.38409697701411, 396.39213938098032);
            double b2 = (355.83704559683667);
            bool2x3 r2 = bool2x3(false, false, false, false, false, true);
            TestUtils.AreEqual(a2 >= b2, r2);

            double2x3 a3 = double2x3(332.66542044871744, -335.121477998384, -302.08690442800844, 254.44223344253476, 179.00504287472234, 71.176674637560154);
            double b3 = (243.76141392614761);
            bool2x3 r3 = bool2x3(true, false, false, true, false, false);
            TestUtils.AreEqual(a3 >= b3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_greater_equal_scalar_wide()
        {
            double a0 = (215.43534169692327);
            double2x3 b0 = double2x3(204.80295310020585, -101.10404853760451, -122.05503827056617, -70.456147941973143, -239.62025677395064, -185.99272426683115);
            bool2x3 r0 = bool2x3(true, true, true, true, true, true);
            TestUtils.AreEqual(a0 >= b0, r0);

            double a1 = (-455.61258027312);
            double2x3 b1 = double2x3(276.66581476697036, 79.39918831707871, 416.42054791768112, 379.27350801009379, -439.51472612820322, 67.141009600433108);
            bool2x3 r1 = bool2x3(false, false, false, false, false, false);
            TestUtils.AreEqual(a1 >= b1, r1);

            double a2 = (-74.560638224035813);
            double2x3 b2 = double2x3(-367.25635474140586, 494.950765601802, -61.235545425319856, -429.17024846988278, -213.82468924942646, -264.31016242891093);
            bool2x3 r2 = bool2x3(true, false, false, true, true, true);
            TestUtils.AreEqual(a2 >= b2, r2);

            double a3 = (243.11378275748052);
            double2x3 b3 = double2x3(-22.383876095704693, 304.86197175870745, -323.68615332417477, 67.938025267765852, 125.30356818312009, -400.47050280145857);
            bool2x3 r3 = bool2x3(true, false, true, true, true, true);
            TestUtils.AreEqual(a3 >= b3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_add_wide_wide()
        {
            double2x3 a0 = double2x3(465.14837644302679, 278.91072548502621, -277.52992237616792, -65.197214395365336, -473.32437561141529, -4.6955420992782138);
            double2x3 b0 = double2x3(483.99436186440028, -204.07667193379098, -365.67356007437854, -509.92086076639634, -270.69751108377125, 486.76397846954126);
            double2x3 r0 = double2x3(949.14273830742707, 74.834053551235229, -643.20348245054652, -575.11807516176168, -744.02188669518659, 482.06843637026304);
            TestUtils.AreEqual(a0 + b0, r0);

            double2x3 a1 = double2x3(-470.53676698661258, -109.95011453980118, -178.70145782209067, -420.03378339299644, 290.71109236903078, -446.5296368294068);
            double2x3 b1 = double2x3(267.49177587567442, 251.6425212601398, 244.4951094335388, -78.675763882079991, 352.20551340291536, 82.779185095233515);
            double2x3 r1 = double2x3(-203.04499111093816, 141.69240672033862, 65.793651611448126, -498.70954727507643, 642.91660577194614, -363.75045173417328);
            TestUtils.AreEqual(a1 + b1, r1);

            double2x3 a2 = double2x3(491.066454400805, -261.11730039358014, -298.40688409395835, 502.42861890347149, 284.59432925125316, 401.12844366632794);
            double2x3 b2 = double2x3(462.54732606492348, -405.492017696375, -428.4983238785054, -41.872599859662614, -269.9274958436971, 75.204465662690041);
            double2x3 r2 = double2x3(953.6137804657285, -666.6093180899552, -726.90520797246381, 460.55601904380887, 14.666833407556055, 476.332909329018);
            TestUtils.AreEqual(a2 + b2, r2);

            double2x3 a3 = double2x3(-36.263498084742366, -102.94915657069026, 503.19817161150195, -384.42911857386542, -45.22821452339565, -198.67394337368847);
            double2x3 b3 = double2x3(-141.91339380196922, -222.1867559990784, 41.305726308983594, 148.33947117083676, -177.23311217931712, -176.51887830370987);
            double2x3 r3 = double2x3(-178.17689188671159, -325.13591256976866, 544.50389792048554, -236.08964740302866, -222.46132670271277, -375.19282167739834);
            TestUtils.AreEqual(a3 + b3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_add_wide_scalar()
        {
            double2x3 a0 = double2x3(459.89829728561369, -447.66336104258119, -94.438627525436971, 126.42986279652916, -36.254356162741033, -349.64130060264904);
            double b0 = (500.99725913489112);
            double2x3 r0 = double2x3(960.89555642050482, 53.333898092309937, 406.55863160945415, 627.42712193142029, 464.74290297215009, 151.35595853224208);
            TestUtils.AreEqual(a0 + b0, r0);

            double2x3 a1 = double2x3(-2.7912590516690443, 443.11525246273504, 268.092225914864, 41.32102133767728, -471.25607584009697, -2.6649749291431704);
            double b1 = (-478.41478489265535);
            double2x3 r1 = double2x3(-481.20604394432439, -35.299532429920305, -210.32255897779135, -437.09376355497807, -949.67086073275232, -481.07975982179852);
            TestUtils.AreEqual(a1 + b1, r1);

            double2x3 a2 = double2x3(78.985822952811532, 311.7254551908585, 10.345855002452595, -151.24445898423181, 355.23276703210206, -197.80076584490052);
            double b2 = (202.14799151297098);
            double2x3 r2 = double2x3(281.13381446578251, 513.87344670382947, 212.49384651542357, 50.903532528739163, 557.380758545073, 4.34722566807045);
            TestUtils.AreEqual(a2 + b2, r2);

            double2x3 a3 = double2x3(255.95526587961024, -181.6265695940827, -2.4549267303454485, 300.90065469448484, -236.49194895312746, -160.5840962680914);
            double b3 = (244.14709793969394);
            double2x3 r3 = double2x3(500.10236381930417, 62.52052834561124, 241.69217120934849, 545.04775263417878, 7.6551489865664735, 83.563001671602535);
            TestUtils.AreEqual(a3 + b3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_add_scalar_wide()
        {
            double a0 = (-325.51276484388518);
            double2x3 b0 = double2x3(-264.08813178915909, -106.00925998855814, -355.44729320865463, -447.33029362528134, -158.70021040677102, -199.48369154682553);
            double2x3 r0 = double2x3(-589.60089663304427, -431.52202483244332, -680.96005805253981, -772.84305846916652, -484.2129752506562, -524.9964563907107);
            TestUtils.AreEqual(a0 + b0, r0);

            double a1 = (180.31809123806568);
            double2x3 b1 = double2x3(337.57936898692481, -37.05501486596421, 230.80498014707348, -140.17433339924287, 18.02419591789328, -138.61435825126915);
            double2x3 r1 = double2x3(517.89746022499048, 143.26307637210147, 411.12307138513916, 40.143757838822808, 198.34228715595896, 41.703732986796524);
            TestUtils.AreEqual(a1 + b1, r1);

            double a2 = (26.904163611542458);
            double2x3 b2 = double2x3(-374.53758233345, 154.4676006559597, 268.3838204203098, -190.96302255939833, 188.61725362977813, -504.91612386373623);
            double2x3 r2 = double2x3(-347.63341872190756, 181.37176426750216, 295.28798403185226, -164.05885894785587, 215.52141724132059, -478.01196025219377);
            TestUtils.AreEqual(a2 + b2, r2);

            double a3 = (20.454013595568995);
            double2x3 b3 = double2x3(197.94534525552081, 251.41194474483461, -421.09037538109828, 111.44540052835146, -73.268883024001923, 480.88455770950975);
            double2x3 r3 = double2x3(218.3993588510898, 271.86595834040361, -400.63636178552929, 131.89941412392045, -52.814869428432928, 501.33857130507874);
            TestUtils.AreEqual(a3 + b3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_sub_wide_wide()
        {
            double2x3 a0 = double2x3(133.37101680290471, -131.8321183341705, -197.29314407952739, -485.286571013409, -337.55033103448818, 471.66710470228782);
            double2x3 b0 = double2x3(123.46028739002543, 359.56010048443454, -48.24847819667707, 478.97904680621764, 207.15832886805686, 142.36730462981723);
            double2x3 r0 = double2x3(9.9107294128792773, -491.39221881860504, -149.04466588285032, -964.26561781962664, -544.708659902545, 329.29980007247059);
            TestUtils.AreEqual(a0 - b0, r0);

            double2x3 a1 = double2x3(146.5066197600712, -130.58504372955537, 110.77707367333448, -235.54160486699158, 78.879356659427, -347.68616811730254);
            double2x3 b1 = double2x3(-125.60551005490379, -65.299004823574307, -477.876434787119, 164.50000031501986, 428.00958915614035, 72.6278169493321);
            double2x3 r1 = double2x3(272.112129814975, -65.286038905981059, 588.65350846045351, -400.04160518201144, -349.13023249671335, -420.31398506663464);
            TestUtils.AreEqual(a1 - b1, r1);

            double2x3 a2 = double2x3(-470.82054565419469, -11.459293609233271, -167.94791730118351, 330.67676917215658, -508.35086822339838, -252.03190457636111);
            double2x3 b2 = double2x3(-446.880505531505, 432.09146114443035, -225.55465637219822, -112.45196705332586, -210.61278853687122, -172.92506011432272);
            double2x3 r2 = double2x3(-23.940040122689709, -443.55075475366363, 57.606739071014715, 443.12873622548244, -297.73807968652716, -79.1068444620384);
            TestUtils.AreEqual(a2 - b2, r2);

            double2x3 a3 = double2x3(-427.93418737311578, 192.6576150360786, 168.42931016182024, 457.3087858899072, 470.05851457550125, -299.71188058504458);
            double2x3 b3 = double2x3(-80.60749415336528, 270.04610861001822, -154.25558550388348, 148.47577745675846, 13.661130673094249, 70.671096596248049);
            double2x3 r3 = double2x3(-347.3266932197505, -77.388493573939627, 322.68489566570372, 308.83300843314873, 456.397383902407, -370.38297718129263);
            TestUtils.AreEqual(a3 - b3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_sub_wide_scalar()
        {
            double2x3 a0 = double2x3(48.936717294592768, 410.45158953706346, -364.44171612544062, 163.98060353285666, -460.06732318367222, 110.91942339340198);
            double b0 = (-291.59041442144212);
            double2x3 r0 = double2x3(340.52713171603489, 702.04200395850557, -72.8513017039985, 455.57101795429878, -168.4769087622301, 402.5098378148441);
            TestUtils.AreEqual(a0 - b0, r0);

            double2x3 a1 = double2x3(204.35834441164434, -377.92569344952972, -470.26204297983185, 400.53491968686455, 461.50756499800252, -246.28726660753006);
            double b1 = (180.26971420099483);
            double2x3 r1 = double2x3(24.088630210649512, -558.19540765052454, -650.53175718082662, 220.26520548586973, 281.2378507970077, -426.55698080852488);
            TestUtils.AreEqual(a1 - b1, r1);

            double2x3 a2 = double2x3(21.605312595891405, -121.42736178330489, -122.71842413894757, -122.93872099879138, 360.15095417581074, 342.87457887403411);
            double b2 = (246.35072171238755);
            double2x3 r2 = double2x3(-224.74540911649615, -367.77808349569244, -369.06914585133512, -369.28944271117894, 113.80023246342319, 96.523857161646561);
            TestUtils.AreEqual(a2 - b2, r2);

            double2x3 a3 = double2x3(18.929827460520869, 97.0436885808798, 485.9149813530571, -205.75765690848124, 253.44322717070725, -121.16305619159857);
            double b3 = (164.60235245740148);
            double2x3 r3 = double2x3(-145.67252499688061, -67.558663876521678, 321.31262889565562, -370.36000936588272, 88.840874713305766, -285.76540864900005);
            TestUtils.AreEqual(a3 - b3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_sub_scalar_wide()
        {
            double a0 = (294.58645905861);
            double2x3 b0 = double2x3(452.35251757705237, 256.98980891750648, -275.159888634067, -89.027518075437968, 488.22838829840919, -333.21728030462623);
            double2x3 r0 = double2x3(-157.76605851844238, 37.59665014110351, 569.746347692677, 383.61397713404796, -193.6419292397992, 627.80373936323622);
            TestUtils.AreEqual(a0 - b0, r0);

            double a1 = (-64.232989102710519);
            double2x3 b1 = double2x3(-66.041730196234653, 341.20492831859963, -385.775056303374, 75.394746577085357, 354.94371645289641, 169.13141520746581);
            double2x3 r1 = double2x3(1.8087410935241337, -405.43791742131015, 321.5420672006635, -139.62773567979588, -419.17670555560693, -233.36440431017633);
            TestUtils.AreEqual(a1 - b1, r1);

            double a2 = (88.216608326982964);
            double2x3 b2 = double2x3(1.7350065716240124, 122.53803997977548, -264.94502771317264, -50.837180399725753, -347.65032283759228, 4.0655586738445209);
            double2x3 r2 = double2x3(86.481601755358952, -34.321431652792512, 353.1616360401556, 139.05378872670872, 435.86693116457525, 84.151049653138443);
            TestUtils.AreEqual(a2 - b2, r2);

            double a3 = (-79.095424450512724);
            double2x3 b3 = double2x3(354.35833923628479, -292.4925116470514, -53.208983207684469, -246.34760033634848, 299.20334138497867, 432.18467422583353);
            double2x3 r3 = double2x3(-433.45376368679752, 213.39708719653868, -25.886441242828255, 167.25217588583575, -378.29876583549139, -511.28009867634626);
            TestUtils.AreEqual(a3 - b3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_mul_wide_wide()
        {
            double2x3 a0 = double2x3(-394.78053898121254, -412.37219519744264, -25.874570143350638, -241.04595886964626, -93.675987525692221, 244.15999257013198);
            double2x3 b0 = double2x3(-149.76397831261346, -345.04538671348496, -284.33404721148963, 267.97923648915219, -326.64849558782225, -150.68967754705329);
            double2x3 r0 = double2x3(59123.904078224172, 142287.1235617903, 7357.0212487164608, -64595.312016683383, 30599.120397970968, -36792.390550284115);
            TestUtils.AreEqual(a0 * b0, r0);

            double2x3 a1 = double2x3(494.68846606402121, 53.537962700025105, -239.49641167349017, 236.67584644848284, -211.85620818466703, -216.65482030466887);
            double2x3 b1 = double2x3(207.73243794577775, 366.19289248352538, 358.88076202891807, 214.85359368792433, 253.42280900358355, -307.71382751488773);
            double2x3 r1 = double2x3(102762.84107913627, 19605.221418797286, -85950.654724573629, 50850.6561485879, -53689.195383006307, 66667.684005499876);
            TestUtils.AreEqual(a1 * b1, r1);

            double2x3 a2 = double2x3(467.95832870339893, -178.02191146557311, -386.3942503344241, -422.43540521265726, 464.58952758488692, -251.3156646468284);
            double2x3 b2 = double2x3(184.4711149597872, 426.43644185850235, -144.28142625851621, 459.47961518703016, -358.31334917541284, -201.36521563370025);
            double2x3 r2 = double2x3(86324.794650634591, -75915.030498228327, 55749.513536340863, -194100.45742848891, -166468.62962076368, 50606.233003735295);
            TestUtils.AreEqual(a2 * b2, r2);

            double2x3 a3 = double2x3(-104.97877912641445, -66.934159071619717, -39.829896707008572, 401.56559080703448, 434.14618250082538, -336.45419589451245);
            double2x3 b3 = double2x3(254.90996539541982, 168.52096303204121, 8.7945530455533572, -194.84647974504458, -405.36266178887462, -180.7321890242082);
            double2x3 r3 = double2x3(-26760.136954367728, -11279.808946489193, -350.28613938869785, -78243.6417554897, -175986.65214401312, 60808.103330394995);
            TestUtils.AreEqual(a3 * b3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_mul_wide_scalar()
        {
            double2x3 a0 = double2x3(328.20302191758674, -290.10672272839895, 236.99572454998065, 120.48136692889102, 357.90315811610924, 134.86723214707672);
            double b0 = (192.21119055161773);
            double2x3 r0 = double2x3(63084.293585418032, -55761.758562653624, 45553.230371395039, 23157.866976688449, 68792.992123681237, 25922.99125739103);
            TestUtils.AreEqual(a0 * b0, r0);

            double2x3 a1 = double2x3(-477.31047104173825, -46.729179165665585, -238.40500103608008, 422.08249374017237, -48.83483722099794, 355.30832998608628);
            double b1 = (-438.272912467957);
            double2x3 r1 = double2x3(209192.25029491508, 20480.133450173231, 104486.45415100912, -184987.32383324357, 21402.986338745359, -155722.01660712797);
            TestUtils.AreEqual(a1 * b1, r1);

            double2x3 a2 = double2x3(119.35660391643489, 98.2360046367329, -325.55215683837991, 53.937323833786536, -87.4509838034636, -130.47412949915702);
            double b2 = (-196.995807977857);
            double2x3 r2 = double2x3(-23512.750626011144, -19352.081105929705, 64132.410175310673, -10625.426688800102, 17227.4772128218, 25702.856560893983);
            TestUtils.AreEqual(a2 * b2, r2);

            double2x3 a3 = double2x3(-222.59457145565869, 293.36108769726059, 174.38195737375963, -327.12007704708731, 56.629123475695565, 257.54154241156834);
            double b3 = (126.01503211167415);
            double2x3 r3 = double2x3(-28050.262069869175, 36967.906886485951, 21974.747958150911, -41222.047013462026, 7136.1208132457368, 32454.105737083875);
            TestUtils.AreEqual(a3 * b3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_mul_scalar_wide()
        {
            double a0 = (-464.534700371574);
            double2x3 b0 = double2x3(329.36093846399376, -198.68342671109525, 184.07942518223047, 256.01618754864489, 266.22629297255833, -97.894749448585685);
            double2x3 r0 = double2x3(-152999.58486347177, 92295.346096036214, -85511.280621599, -118928.40297318244, -123671.35123704225, 45475.508103049062);
            TestUtils.AreEqual(a0 * b0, r0);

            double a1 = (159.74810583877752);
            double2x3 b1 = double2x3(-351.82222263506719, 491.80157660497423, 49.902031206480274, 424.46256871915546, 160.11807616060514, -395.99208492599058);
            double2x3 r1 = double2x3(-56202.933657940659, 78564.37031116907, 7971.75496274279, 67807.091352347023, 25578.559377205791, -63258.985494075321);
            TestUtils.AreEqual(a1 * b1, r1);

            double a2 = (125.20168858636248);
            double2x3 b2 = double2x3(-265.01581991138676, 314.65609779705107, -292.71202029507236, -37.729878681586058, 165.3622206027444, 356.51773302467438);
            double2x3 r2 = double2x3(-33180.428155004964, 39395.4747681864, -36648.039210468662, -4723.8445210931741, 20703.629247854176, 44636.6221856712);
            TestUtils.AreEqual(a2 * b2, r2);

            double a3 = (-188.81332906932261);
            double2x3 b3 = double2x3(504.91572475103465, 40.572113771257932, -206.77510581108515, -61.602680473403382, 118.97158938225903, 53.7483275186961);
            double2x3 r3 = double2x3(-95334.818889692615, -7660.55586853052, 39041.896096852419, 11631.407179777047, -22463.4218559328, -10148.400650713294);
            TestUtils.AreEqual(a3 * b3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_div_wide_wide()
        {
            double2x3 a0 = double2x3(246.26574933075619, -269.85612953354428, -451.61952588130697, -7.38850236283082, -308.20558681534862, -373.394808704683);
            double2x3 b0 = double2x3(172.11981423763552, -77.141104972521362, -325.8353723612779, -450.60868117334724, -261.26215398556656, -122.44949847201326);
            double2x3 r0 = double2x3(1.4307809383918566, 3.4982144685336105, 1.3860359070548143, 0.016396715535066435, 1.1796794220427942, 3.0493780159501847);
            TestUtils.AreEqual(a0 / b0, r0);

            double2x3 a1 = double2x3(360.41863482092447, 25.80972458133931, -274.050461181463, 127.53858977534742, -447.6717600522897, -137.4586017771897);
            double2x3 b1 = double2x3(-93.210781379235357, -442.00522705633438, 484.36271380091216, -390.78178686219348, 402.02531714086672, 316.65072193585831);
            double2x3 r1 = double2x3(-3.8667054335113131, -0.05839235149599218, -0.56579594872388561, -0.32636779415802974, -1.1135412148569459, -0.43410165287743668);
            TestUtils.AreEqual(a1 / b1, r1);

            double2x3 a2 = double2x3(-136.13317424437645, 12.43763423545181, 228.51298319013461, 356.9723681681661, -24.762040865031111, 411.66839356518744);
            double2x3 b2 = double2x3(397.15440744774151, -303.26218643005109, -118.59124451437555, -81.650312223308845, -84.346871176896116, -488.41943549011808);
            double2x3 r2 = double2x3(-0.3427714050039572, -0.041012809351094658, -1.9268959030313104, -4.37196574572633, 0.29357391115432163, -0.84285833783843456);
            TestUtils.AreEqual(a2 / b2, r2);

            double2x3 a3 = double2x3(-204.07890067066944, 11.365393882321882, 82.152295389283609, 37.389483230835481, 394.26582903147948, -429.91279645912016);
            double2x3 b3 = double2x3(404.16049999937434, -136.72883731533256, -19.832707652744261, -102.6072290421497, 166.11604960547572, -112.84016590604568);
            double2x3 r3 = double2x3(-0.50494519051462317, -0.083123605125890912, -4.1422632162843458, -0.36439423985883462, 2.3734361006528726, 3.8099270149698223);
            TestUtils.AreEqual(a3 / b3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_div_wide_scalar()
        {
            double2x3 a0 = double2x3(-244.51745116175965, 69.112274917360537, -333.02311888943575, 257.39682519500923, 403.24561257066466, 154.34436066185322);
            double b0 = (-60.024377612408443);
            double2x3 r0 = double2x3(4.0736357608014941, -1.1514034408425655, 5.5481311449798705, -4.2882048166676752, -6.7180307170282818, -2.5713612835520117);
            TestUtils.AreEqual(a0 / b0, r0);

            double2x3 a1 = double2x3(131.52659160062979, -348.92380516087815, -275.53868187383688, 210.55792174607416, 287.64239968342815, 504.37224626185946);
            double b1 = (-261.88639200007844);
            double2x3 r1 = double2x3(-0.50222766672271535, 1.332347979198452, 1.0521305813925388, -0.80400482109055549, -1.0983480183397309, -1.9259200236020984);
            TestUtils.AreEqual(a1 / b1, r1);

            double2x3 a2 = double2x3(491.78708600056689, -253.23667275776933, 272.89512098622276, 178.09617313095191, -460.87559030059521, -502.64601611655485);
            double b2 = (-26.63160015392657);
            double2x3 r2 = double2x3(-18.466298801353012, 9.50887934987384, -10.247041837851679, -6.6874003853160646, 17.305591389056794, 18.874044864421883);
            TestUtils.AreEqual(a2 / b2, r2);

            double2x3 a3 = double2x3(-84.324793139623864, 83.796309271732525, 197.04206690427009, 317.16826525198678, 403.38711781212464, 81.646461763254592);
            double b3 = (-174.69034036187935);
            double2x3 r3 = double2x3(0.48271010844069023, -0.47968484747436224, -1.1279505580908942, -1.815602766558, -2.309155257105167, -0.4673782282072384);
            TestUtils.AreEqual(a3 / b3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_div_scalar_wide()
        {
            double a0 = (41.737658758525527);
            double2x3 b0 = double2x3(-422.676129776368, 248.12963235011773, 449.39137741988122, 245.85813796047967, -326.62061253498337, 163.71510489457989);
            double2x3 r0 = double2x3(-0.098746193168297289, 0.1682090863683405, 0.092875967042706856, 0.16976317767945767, -0.12778635871933872, 0.25494079355354177);
            TestUtils.AreEqual(a0 / b0, r0);

            double a1 = (333.664472020075);
            double2x3 b1 = double2x3(38.291076916405473, -472.97976062864984, 192.23013958345643, -200.29686960964318, -490.18150376257557, -211.10257468517057);
            double2x3 r1 = double2x3(8.7138962622678129, -0.70545190258583745, 1.7357552397511267, -1.6658496594098089, -0.68069576158811729, -1.5805798319498852);
            TestUtils.AreEqual(a1 / b1, r1);

            double a2 = (-322.85234108700058);
            double2x3 b2 = double2x3(-137.98529035317961, 84.32973555677097, 355.06345550858578, 276.42724455354141, -382.9880213136729, -488.647160996053);
            double2x3 r2 = double2x3(2.3397591167916914, -3.8284519565421338, -0.909280682306641, -1.1679468918067049, 0.8429828692281206, 0.660706470552089);
            TestUtils.AreEqual(a2 / b2, r2);

            double a3 = (344.84603826368505);
            double2x3 b3 = double2x3(168.85499938244698, -44.19558837087618, 420.550703959796, -175.6152060849663, -9.2205684227964753, -344.19428865248074);
            double2x3 r3 = double2x3(2.0422613456805525, -7.8027253618582941, 0.81998682921394372, -1.9636456657223711, -37.399650699527896, -1.0018935514989395);
            TestUtils.AreEqual(a3 / b3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_mod_wide_wide()
        {
            double2x3 a0 = double2x3(-442.30985924336585, 368.50046246522129, -1.0938966279355213, -364.67383473211612, -197.34394487987458, -34.034902350062);
            double2x3 b0 = double2x3(-43.245045443645211, -144.19587690392319, -62.640481739603217, -336.82826510855381, -154.6102545981343, -154.02935583611452);
            double2x3 r0 = double2x3(-9.8594048069137443, 80.1087086573749, -1.0938966279355213, -27.845569623562312, -42.73369028174028, -34.034902350062);
            TestUtils.AreEqual(a0 % b0, r0);

            double2x3 a1 = double2x3(-101.34858350704826, 208.31857142612273, -140.77031404374645, 183.446989383291, -463.36838100076113, 83.839106360375467);
            double2x3 b1 = double2x3(487.0462093237071, -469.82909105244516, -145.20377237405802, -203.38401780062543, -22.520082245823062, 224.6900237652892);
            double2x3 r1 = double2x3(-101.34858350704826, 208.31857142612273, -140.77031404374645, 183.446989383291, -12.966736084299896, 83.839106360375467);
            TestUtils.AreEqual(a1 % b1, r1);

            double2x3 a2 = double2x3(-64.714058190916717, 295.06681050689281, 212.257051805154, 349.62829916068745, 119.87592106679267, -37.805828350505692);
            double2x3 b2 = double2x3(-435.62674614210925, 12.095571285158144, 40.378765363422531, 345.78484813579587, -433.47126146474443, -355.64996712079733);
            double2x3 r2 = double2x3(-64.714058190916717, 4.773099663097355, 10.363224988041338, 3.8434510248915785, 119.87592106679267, -37.805828350505692);
            TestUtils.AreEqual(a2 % b2, r2);

            double2x3 a3 = double2x3(142.41158515886013, 332.24425593588694, -464.19427249589671, -296.14783801517814, 225.17535863871467, -212.06027732233531);
            double2x3 b3 = double2x3(4.0154273528677322, 66.659781725453058, -221.85363088448236, -355.05676405274158, 357.93597118832918, 71.375334057666009);
            double2x3 r3 = double2x3(1.8716278084895066, 65.605129034074707, -20.487010726932, -296.14783801517814, 225.17535863871467, -69.309609207003291);
            TestUtils.AreEqual(a3 % b3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_mod_wide_scalar()
        {
            double2x3 a0 = double2x3(-433.41699548876704, -5.5141427542614565, 393.39439958771425, 299.41153277988155, -120.80601626299602, -502.939041133476);
            double b0 = (-90.499235433758827);
            double2x3 r0 = double2x3(-71.420053753731736, -5.5141427542614565, 31.39745785267894, 27.913826478605074, -30.306780829237198, -50.442863964681862);
            TestUtils.AreEqual(a0 % b0, r0);

            double2x3 a1 = double2x3(-450.80766245853511, -84.473635951277629, -318.78148356023314, 433.45469041981482, -54.6001856581309, -172.33886607565864);
            double b1 = (186.09479698263794);
            double2x3 r1 = double2x3(-78.618068493259216, -84.473635951277629, -132.6866865775952, 61.265096454538934, -54.6001856581309, -172.33886607565864);
            TestUtils.AreEqual(a1 % b1, r1);

            double2x3 a2 = double2x3(-429.71466728193434, 5.796394112425105, 254.51082885196, -433.09369703433185, -203.08261284748215, -75.356399809641971);
            double b2 = (222.36186109406958);
            double2x3 r2 = double2x3(-207.35280618786476, 5.796394112425105, 32.148967757890432, -210.73183594026227, -203.08261284748215, -75.356399809641971);
            TestUtils.AreEqual(a2 % b2, r2);

            double2x3 a3 = double2x3(252.28909385031511, 5.3372299696026175, -279.06042803407666, 483.55059097872606, -331.99334660730949, 335.99997655302286);
            double b3 = (-69.403906139267576);
            double2x3 r3 = double2x3(44.077375432512383, 5.3372299696026175, -1.44480347700636, 67.1271541431206, -54.377722050239186, 58.384351995952557);
            TestUtils.AreEqual(a3 % b3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_mod_scalar_wide()
        {
            double a0 = (-396.4224028049141);
            double2x3 b0 = double2x3(-159.14024384279747, 230.17333399046834, 14.779358632294134, -303.15649738123477, 399.63502020371845, 206.69470534412881);
            double2x3 r0 = double2x3(-78.141915119319151, -166.24906881444576, -12.159078365266623, -93.265905423679328, -396.4224028049141, -189.72769746078529);
            TestUtils.AreEqual(a0 % b0, r0);

            double a1 = (397.04482263934096);
            double2x3 b1 = double2x3(-393.89064735634747, -372.06709426085797, 201.01229796233224, -95.5668547598491, -258.95146882671463, 106.98357563232241);
            double2x3 r1 = double2x3(3.1541752829934921, 24.977728378482993, 196.03252467700872, 14.777403599944591, 138.09335381262633, 76.094095742373725);
            TestUtils.AreEqual(a1 % b1, r1);

            double a2 = (469.3235559264773);
            double2x3 b2 = double2x3(-34.808985011097491, 184.83653434777466, 374.79425376224992, -131.87271911086174, -120.09286003936683, 4.506670715523228);
            double2x3 r2 = double2x3(16.806750782209917, 99.650487230927979, 94.529302164227374, 73.705398593892085, 109.04497580837682, 0.62980151206159007);
            TestUtils.AreEqual(a2 % b2, r2);

            double a3 = (-111.40195732535886);
            double2x3 b3 = double2x3(391.54249710195813, -218.66887078931035, 196.37741980160467, -511.03262233689082, 499.95350598727987, -433.52306505363578);
            double2x3 r3 = double2x3(-111.40195732535886, -111.40195732535886, -111.40195732535886, -111.40195732535886, -111.40195732535886, -111.40195732535886);
            TestUtils.AreEqual(a3 % b3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_plus()
        {
            double2x3 a0 = double2x3(271.6708086802023, -79.080240524876956, -330.98506203805334, 31.824682965793045, 315.44952860262686, 319.22218742930431);
            double2x3 r0 = double2x3(271.6708086802023, -79.080240524876956, -330.98506203805334, 31.824682965793045, 315.44952860262686, 319.22218742930431);
            TestUtils.AreEqual(+a0, r0);

            double2x3 a1 = double2x3(190.32466015141677, -320.51845875406565, 102.0544069288552, -107.00351267075331, -428.77622075973835, 377.23016208095021);
            double2x3 r1 = double2x3(190.32466015141677, -320.51845875406565, 102.0544069288552, -107.00351267075331, -428.77622075973835, 377.23016208095021);
            TestUtils.AreEqual(+a1, r1);

            double2x3 a2 = double2x3(234.77393042052813, 258.33039414991174, 465.35593555185756, 309.59316530339106, -316.93713655925222, -230.05266557915724);
            double2x3 r2 = double2x3(234.77393042052813, 258.33039414991174, 465.35593555185756, 309.59316530339106, -316.93713655925222, -230.05266557915724);
            TestUtils.AreEqual(+a2, r2);

            double2x3 a3 = double2x3(301.78512229667285, 350.24640981771347, 60.819777278611355, -472.44209526127304, -364.80255644619581, 239.15236937215195);
            double2x3 r3 = double2x3(301.78512229667285, 350.24640981771347, 60.819777278611355, -472.44209526127304, -364.80255644619581, 239.15236937215195);
            TestUtils.AreEqual(+a3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_neg()
        {
            double2x3 a0 = double2x3(420.22718854445372, -196.25749811728366, -335.42683068636188, 509.04366969924592, -33.014395013923945, -498.57532071442125);
            double2x3 r0 = double2x3(-420.22718854445372, 196.25749811728366, 335.42683068636188, -509.04366969924592, 33.014395013923945, 498.57532071442125);
            TestUtils.AreEqual(-a0, r0);

            double2x3 a1 = double2x3(-495.8379526063045, 19.686896571743773, 268.23670662019254, -180.60051473444349, 223.38126312167446, -410.39206070936848);
            double2x3 r1 = double2x3(495.8379526063045, -19.686896571743773, -268.23670662019254, 180.60051473444349, -223.38126312167446, 410.39206070936848);
            TestUtils.AreEqual(-a1, r1);

            double2x3 a2 = double2x3(-395.68154186554324, -110.9393032113739, -238.21960913307015, 292.54351224216794, 469.29257867731735, 48.290685914592245);
            double2x3 r2 = double2x3(395.68154186554324, 110.9393032113739, 238.21960913307015, -292.54351224216794, -469.29257867731735, -48.290685914592245);
            TestUtils.AreEqual(-a2, r2);

            double2x3 a3 = double2x3(88.7237785275671, 55.707977559281517, 464.54141090090457, 499.24280213715645, 175.01502259774838, 196.38759169186824);
            double2x3 r3 = double2x3(-88.7237785275671, -55.707977559281517, -464.54141090090457, -499.24280213715645, -175.01502259774838, -196.38759169186824);
            TestUtils.AreEqual(-a3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_prefix_inc()
        {
            double2x3 a0 = double2x3(-99.79557113526181, 458.74185082816609, 96.179026886904126, -48.552469514567633, -315.728967098393, -299.23014583216525);
            double2x3 r0 = double2x3(-98.79557113526181, 459.74185082816609, 97.179026886904126, -47.552469514567633, -314.728967098393, -298.23014583216525);
            TestUtils.AreEqual(++a0, r0);

            double2x3 a1 = double2x3(-323.61485853959567, -76.507656371457358, -305.58477344437722, 64.0964734852763, 148.67930967578627, 363.2849182390072);
            double2x3 r1 = double2x3(-322.61485853959567, -75.507656371457358, -304.58477344437722, 65.0964734852763, 149.67930967578627, 364.2849182390072);
            TestUtils.AreEqual(++a1, r1);

            double2x3 a2 = double2x3(-115.5592263283018, -179.89464839729231, 339.8765849265626, -38.410431164507941, -153.3736775635619, 261.62557304167444);
            double2x3 r2 = double2x3(-114.5592263283018, -178.89464839729231, 340.8765849265626, -37.410431164507941, -152.3736775635619, 262.62557304167444);
            TestUtils.AreEqual(++a2, r2);

            double2x3 a3 = double2x3(155.03081877298223, 301.30576791488829, -221.35540328796736, -429.69815011960367, -271.28932893988178, -264.38006246480165);
            double2x3 r3 = double2x3(156.03081877298223, 302.30576791488829, -220.35540328796736, -428.69815011960367, -270.28932893988178, -263.38006246480165);
            TestUtils.AreEqual(++a3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_postfix_inc()
        {
            double2x3 a0 = double2x3(322.94356623429042, 472.05246542024076, 203.48761925636211, -49.854570650427888, -31.420532002775246, 455.33662459595905);
            double2x3 r0 = double2x3(322.94356623429042, 472.05246542024076, 203.48761925636211, -49.854570650427888, -31.420532002775246, 455.33662459595905);
            TestUtils.AreEqual(a0++, r0);

            double2x3 a1 = double2x3(271.45466840986842, 153.75031645305, -174.17301925186672, -427.40105100506969, 215.11022744658874, 159.86103184514729);
            double2x3 r1 = double2x3(271.45466840986842, 153.75031645305, -174.17301925186672, -427.40105100506969, 215.11022744658874, 159.86103184514729);
            TestUtils.AreEqual(a1++, r1);

            double2x3 a2 = double2x3(-333.05045262586816, 287.22045649551808, -170.10464366250886, -270.65246380057766, -162.86024792625579, 454.48881003562769);
            double2x3 r2 = double2x3(-333.05045262586816, 287.22045649551808, -170.10464366250886, -270.65246380057766, -162.86024792625579, 454.48881003562769);
            TestUtils.AreEqual(a2++, r2);

            double2x3 a3 = double2x3(-449.92732045144186, -311.43587103087259, 69.731466087387616, -232.29964433996923, -341.49855271982892, 188.00656685047159);
            double2x3 r3 = double2x3(-449.92732045144186, -311.43587103087259, 69.731466087387616, -232.29964433996923, -341.49855271982892, 188.00656685047159);
            TestUtils.AreEqual(a3++, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_prefix_dec()
        {
            double2x3 a0 = double2x3(-416.20121712992022, -96.637880131899351, -50.145671629414721, -207.31644759295341, 439.47906156977592, -304.40081920493435);
            double2x3 r0 = double2x3(-417.20121712992022, -97.637880131899351, -51.145671629414721, -208.31644759295341, 438.47906156977592, -305.40081920493435);
            TestUtils.AreEqual(--a0, r0);

            double2x3 a1 = double2x3(337.96895734312432, 171.96452935597142, -227.44280134301761, 298.28480710568135, 326.50782338087811, 400.720900006928);
            double2x3 r1 = double2x3(336.96895734312432, 170.96452935597142, -228.44280134301761, 297.28480710568135, 325.50782338087811, 399.720900006928);
            TestUtils.AreEqual(--a1, r1);

            double2x3 a2 = double2x3(-478.03137253133178, -24.584499132160317, 112.79684668071422, -341.97629300783217, -503.27416181158003, -79.635249413380052);
            double2x3 r2 = double2x3(-479.03137253133178, -25.584499132160317, 111.79684668071422, -342.97629300783217, -504.27416181158003, -80.635249413380052);
            TestUtils.AreEqual(--a2, r2);

            double2x3 a3 = double2x3(-131.0041454448384, -15.70865417258284, 188.75845274178243, 307.79193582562357, -406.667706917351, 181.47510703908051);
            double2x3 r3 = double2x3(-132.0041454448384, -16.70865417258284, 187.75845274178243, 306.79193582562357, -407.667706917351, 180.47510703908051);
            TestUtils.AreEqual(--a3, r3);
        }

        [TestCompiler]
        public static void double2x3_operator_postfix_dec()
        {
            double2x3 a0 = double2x3(-376.59242719066907, 16.969734438215255, -0.25066399585949739, -202.32328734282555, 409.55752940175944, 47.856652520530247);
            double2x3 r0 = double2x3(-376.59242719066907, 16.969734438215255, -0.25066399585949739, -202.32328734282555, 409.55752940175944, 47.856652520530247);
            TestUtils.AreEqual(a0--, r0);

            double2x3 a1 = double2x3(-281.11170376516492, -182.40572866350681, 450.12809559801974, -129.23265582380475, -332.15495768755443, -261.00890052551819);
            double2x3 r1 = double2x3(-281.11170376516492, -182.40572866350681, 450.12809559801974, -129.23265582380475, -332.15495768755443, -261.00890052551819);
            TestUtils.AreEqual(a1--, r1);

            double2x3 a2 = double2x3(205.46112570793423, -483.06653784358247, 378.64123433578811, 487.34482287212495, -192.17785772689518, -357.05418960985457);
            double2x3 r2 = double2x3(205.46112570793423, -483.06653784358247, 378.64123433578811, 487.34482287212495, -192.17785772689518, -357.05418960985457);
            TestUtils.AreEqual(a2--, r2);

            double2x3 a3 = double2x3(-396.30206627226528, 115.86774092347719, -20.823201427619551, 323.40538063803933, 379.15614026559342, 311.29903068733358);
            double2x3 r3 = double2x3(-396.30206627226528, 115.86774092347719, -20.823201427619551, 323.40538063803933, 379.15614026559342, 311.29903068733358);
            TestUtils.AreEqual(a3--, r3);
        }


    }
}
