using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.SceneManagement;

public class LoadSpecificScene : MonoBehaviour {

    public string sceneName;
    private Animator fadeSystem;
    private Animator openDoor;

    private void Awake () {
        fadeSystem = GameObject.FindGameObjectWithTag ("FadeSystem").GetComponent<Animator> ();
        openDoor = GameObject.FindGameObjectWithTag ("OpenDoor").GetComponent<Animator> ();
    }

    private void OnTriggerEnter2D (Collider2D collision) {
        if (collision.CompareTag ("Player")) {
            StartCoroutine (LoadNextScene ());
        }
    }

    private IEnumerator LoadNextScene () {
        openDoor.SetTrigger ("Open");
        yield return new WaitForSeconds (1f);
        fadeSystem.SetTrigger ("FadeIn");
        yield return new WaitForSeconds (1f);
        SceneManager.LoadScene (sceneName);
    }
}