using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class PlayerCombat : MonoBehaviour
{

    public Animator animator;

    public Transform attackPoint;

    public LayerMask ennemyLayers;

    public float attackRange = 0.5f;
    public int attackDamagePlayer = 100;

    public float attackAnimationDelay = 0.5f;

    //permet d'avoir du temps entre deux attaque pour ne pas spammer
    //et de les dfinir depuis l'inspector unity
    //plus flexible que de dfinir des secondes directment dans le code avec les Invoke
    public float timeBtwAttack;
    public float startTimeBtwAttack;

    private bool canAttack = true;

    [SerializeField] private AudioClip sword = null;
    private AudioSource perso_AudioSource;

    void Update()
    {

        //permet d'attaquer uniquement si le dlai entre les deux attaques est arriv  0
        //si le joueur est au sol (il ne pas attaquer dans les airs)
        //on bloque les mouvements du joueur le temps de l'animation
        //on reactive quand l'animation d'attaque est fini
        if(timeBtwAttack <= 0) { 
            if (Input.GetKeyDown(KeyCode.C)){

                bool isGrounded = GetComponent<MoveCharacter>().isGrounded;
                    if (isGrounded == true)
                    {
                MoveCharacter.instance.enabled = false;
                MoveCharacter.instance.rb.velocity = Vector3.zero;
                animator.SetFloat("Speed", 0);
                Attack();
                Debug.Log("Attack");
                    
            }

                // on peut bouger apres 0.48f 
             Invoke("canMove", 0.48f);
            timeBtwAttack = startTimeBtwAttack;

            }
        } else
        {
            timeBtwAttack -= Time.deltaTime;
        }
        perso_AudioSource = GetComponent<AudioSource>();
    }

    void Attack()
    {
        if (!canAttack) return;
        //animation attaque
        animator.SetTrigger("Attack");

        //detecte les ennemis  la porte de l'attaque
        Collider2D[] hitEnemies =  Physics2D.OverlapCircleAll(attackPoint.position, attackRange, ennemyLayers);

        perso_AudioSource.PlayOneShot(sword);

        ////et les dtruits
        foreach (Collider2D enemy in hitEnemies)
        {
            enemy.GetComponent<WeakSpot>().TakeDamage(attackDamagePlayer);
        }

        canAttack = false;
        Invoke("EnableAttack", attackAnimationDelay);
    }

    void OnDrawGizmosSelected()
    {
        if (attackPoint == null)
            return;
        
        Gizmos.color = Color.red;
        Gizmos.DrawWireSphere(attackPoint.position, attackRange);
    }
    void  EnableAttack()
    {
        canAttack = true;

    }

    void canMove()
    {
        MoveCharacter.instance.enabled = true;

    }

}
