/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.player;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.OrientationEventListener;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.unity3d.player.AudioVolumeHandler;
import com.unity3d.player.Camera2Wrapper;
import com.unity3d.player.GoogleARCoreApi;
import com.unity3d.player.HFPStatus;
import com.unity3d.player.IUnityPlayerLifecycleEvents;
import com.unity3d.player.NativeLoader;
import com.unity3d.player.NetworkConnectivity;
import com.unity3d.player.PlatformSupport;
import com.unity3d.player.UnityPermissions;
import com.unity3d.player.g;
import com.unity3d.player.h;
import com.unity3d.player.i;
import com.unity3d.player.k;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Scanner;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class UnityPlayer
extends FrameLayout
implements IUnityPlayerLifecycleEvents {
    public static Activity currentActivity = null;
    private int mInitialScreenOrientation = -1;
    private boolean mMainDisplayOverride = false;
    private boolean mIsFullscreen = true;
    private i mState = new i();
    private final ConcurrentLinkedQueue m_Events = new ConcurrentLinkedQueue();
    private BroadcastReceiver mKillingIsMyBusiness = null;
    private OrientationEventListener mOrientationListener = null;
    private int mNaturalOrientation;
    private static final int ANR_TIMEOUT_SECONDS = 4;
    private static final int RUN_STATE_CHANGED_MSG_CODE = 2269;
    e m_MainThread = new e(0);
    private boolean m_AddPhoneCallListener = false;
    private c m_PhoneCallListener = new c(0);
    private TelephonyManager m_TelephonyManager;
    private ClipboardManager m_ClipboardManager;
    private g m_SplashScreen;
    private GoogleARCoreApi m_ARCoreApi = null;
    private a m_FakeListener = new a();
    private Camera2Wrapper m_Camera2Wrapper = null;
    private HFPStatus m_HFPStatus = null;
    private AudioVolumeHandler m_AudioVolumeHandler = null;
    private Uri m_launchUri = null;
    private NetworkConnectivity m_NetworkConnectivity = null;
    private IUnityPlayerLifecycleEvents m_UnityPlayerLifecycleEvents = null;
    private Context mContext;
    private SurfaceView mGlView;
    private boolean mQuitting;
    private boolean mProcessKillRequested = true;
    private k mVideoPlayerProxy;
    com.unity3d.player.f mSoftInputDialog = null;
    private static final String SPLASH_ENABLE_METADATA_NAME = "unity.splash-enable";
    private static final String SPLASH_MODE_METADATA_NAME = "unity.splash-mode";
    private static final String ARCORE_ENABLE_METADATA_NAME = "unity.arcore-enable";

    public UnityPlayer(Context context) {
        this(context, null);
    }

    public UnityPlayer(Context object, IUnityPlayerLifecycleEvents object2) {
        super(object);
        IUnityPlayerLifecycleEvents iUnityPlayerLifecycleEvents = this.m_UnityPlayerLifecycleEvents = object2 != null ? object2 : this;
        if (object instanceof Activity) {
            currentActivity = (Activity)object;
            this.mInitialScreenOrientation = currentActivity.getRequestedOrientation();
            this.m_launchUri = currentActivity.getIntent().getData();
        }
        this.EarlyEnableFullScreenIfVrLaunched(currentActivity);
        this.mContext = object;
        object2 = this.getResources().getConfiguration();
        this.mNaturalOrientation = this.getNaturalOrientation(((Configuration)object2).orientation);
        if (currentActivity != null && this.getSplashEnabled()) {
            this.m_SplashScreen = new g(this.mContext, g.a.a()[this.getSplashMode()]);
            this.addView(this.m_SplashScreen);
        }
        object2 = UnityPlayer.loadNative(UnityPlayer.getUnityNativeLibraryPath(object));
        if (!i.c()) {
            object = "Your hardware does not support this application.";
            com.unity3d.player.d.Log(6, (String)object);
            object = new AlertDialog.Builder(this.mContext).setTitle((CharSequence)"Failure to initialize!").setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                public final void onClick(DialogInterface dialogInterface, int n) {
                    UnityPlayer.this.finish();
                }
            }).setMessage((CharSequence)((String)object + "\n\n" + (String)object2 + "\n\n Press OK to quit.")).create();
            object.setCancelable(false);
            object.show();
            return;
        }
        this.initJni((Context)object);
        this.mState.c(true);
        this.mGlView = this.CreateGlView();
        this.mGlView.setContentDescription((CharSequence)this.GetGlViewContentDescription((Context)object));
        this.addView((View)this.mGlView);
        this.bringChildToFront(this.m_SplashScreen);
        this.mQuitting = false;
        if (this.mContext instanceof Activity) {
            object = ((Activity)this.mContext).getWindow();
            object.addFlags(0x200000);
            object.addFlags(524288);
            object.addFlags(0x400000);
        }
        this.mKillingIsMyBusiness = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                UnityPlayer.this.finish();
            }
        };
        this.mContext.registerReceiver(this.mKillingIsMyBusiness, new IntentFilter("com.unity3d.intent.action.SHUTDOWN"));
        this.hideStatusBar();
        this.m_TelephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        this.m_ClipboardManager = (ClipboardManager)this.mContext.getSystemService("clipboard");
        this.m_Camera2Wrapper = new Camera2Wrapper(this.mContext);
        this.m_HFPStatus = new HFPStatus(this.mContext);
        this.m_MainThread.start();
    }

    private int getNaturalOrientation(int n) {
        int n2 = ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay().getRotation();
        if ((n2 == 0 || n2 == 2) && n == 2 || (n2 == 1 || n2 == 3) && n == 1) {
            return 0;
        }
        return 1;
    }

    @Override
    public void onUnityPlayerUnloaded() {
        com.unity3d.player.d.Log(4, "onUnityPlayerUnloaded, pass IUnityPlayerLifecycleEvents to UnityPlayer constructor or override this method in child class");
    }

    @Override
    public void onUnityPlayerQuitted() {
        com.unity3d.player.d.Log(4, "onUnityPlayerQuitted, pass IUnityPlayerLifecycleEvents to UnityPlayer constructor or override this method in child class");
    }

    protected void toggleGyroscopeSensor(boolean bl) {
        SensorManager sensorManager = (SensorManager)this.mContext.getSystemService("sensor");
        Sensor sensor = sensorManager.getDefaultSensor(11);
        if (bl) {
            sensorManager.registerListener((SensorEventListener)this.m_FakeListener, sensor, 1);
            return;
        }
        sensorManager.unregisterListener((SensorEventListener)this.m_FakeListener);
    }

    private String GetGlViewContentDescription(Context context) {
        return context.getResources().getString(context.getResources().getIdentifier("game_view_content_description", "string", context.getPackageName()));
    }

    private void DisableStaticSplashScreen() {
        this.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                UnityPlayer.this.removeView(UnityPlayer.this.m_SplashScreen);
                UnityPlayer.this.m_SplashScreen = null;
            }
        });
    }

    private void EarlyEnableFullScreenIfVrLaunched(Activity activity) {
        if (activity != null && activity.getIntent().getBooleanExtra("android.intent.extra.VR_LAUNCH", false) && activity.getWindow() != null && (activity = activity.getWindow().getDecorView()) != null) {
            activity.setSystemUiVisibility(7);
        }
    }

    private boolean IsWindowTranslucent() {
        if (currentActivity == null) {
            return false;
        }
        TypedArray typedArray = currentActivity.getTheme().obtainStyledAttributes(new int[]{16842840});
        boolean bl = typedArray.getBoolean(0, false);
        typedArray.recycle();
        return bl;
    }

    private SurfaceView CreateGlView() {
        SurfaceView surfaceView = new SurfaceView(this.mContext);
        surfaceView.setId(this.mContext.getResources().getIdentifier("unitySurfaceView", "id", this.mContext.getPackageName()));
        if (this.IsWindowTranslucent()) {
            surfaceView.getHolder().setFormat(-3);
            surfaceView.setZOrderOnTop(true);
        } else {
            surfaceView.getHolder().setFormat(-1);
        }
        surfaceView.getHolder().addCallback(new SurfaceHolder.Callback(){

            public final void surfaceCreated(SurfaceHolder surfaceHolder) {
                UnityPlayer.this.updateGLDisplay(0, surfaceHolder.getSurface());
            }

            public final void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
                UnityPlayer.this.updateGLDisplay(0, surfaceHolder.getSurface());
                UnityPlayer.this.sendSurfaceChangedEvent();
            }

            public final void surfaceDestroyed(SurfaceHolder surfaceHolder) {
                UnityPlayer.this.updateGLDisplay(0, null);
            }
        });
        surfaceView.setFocusable(true);
        surfaceView.setFocusableInTouchMode(true);
        return surfaceView;
    }

    private void sendSurfaceChangedEvent() {
        if (!i.c() || !this.mState.e()) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public final void run() {
                UnityPlayer.this.nativeSendSurfaceChangedEvent();
            }
        };
        this.m_MainThread.d(runnable);
    }

    private void updateGLDisplay(int n, Surface surface) {
        if (this.mMainDisplayOverride) {
            return;
        }
        this.updateDisplayInternal(n, surface);
    }

    private boolean updateDisplayInternal(final int n, final Surface surface) {
        if (!i.c() || !this.mState.e()) {
            return false;
        }
        final Semaphore semaphore = new Semaphore(0);
        Runnable runnable = new Runnable(){

            @Override
            public final void run() {
                UnityPlayer.this.nativeRecreateGfxState(n, surface);
                semaphore.release();
            }
        };
        if (n == 0) {
            if (surface == null) {
                this.m_MainThread.b(runnable);
            } else {
                this.m_MainThread.c(runnable);
            }
        } else {
            runnable.run();
        }
        if (surface == null && n == 0) {
            try {
                if (!semaphore.tryAcquire(4L, TimeUnit.SECONDS)) {
                    com.unity3d.player.d.Log(5, "Timeout while trying detaching primary window.");
                }
            }
            catch (InterruptedException interruptedException) {
                com.unity3d.player.d.Log(5, "UI thread got interrupted while trying to detach the primary window from the Unity Engine.");
            }
        }
        return true;
    }

    public boolean displayChanged(int n, Surface surface) {
        if (n == 0) {
            this.mMainDisplayOverride = surface != null;
            this.runOnUiThread(new Runnable(){

                @Override
                public final void run() {
                    if (UnityPlayer.this.mMainDisplayOverride) {
                        UnityPlayer.this.removeView((View)UnityPlayer.this.mGlView);
                        return;
                    }
                    UnityPlayer.this.addView((View)UnityPlayer.this.mGlView);
                }
            });
        }
        return this.updateDisplayInternal(n, surface);
    }

    public static void UnitySendMessage(String string, String string2, String string3) {
        if (!i.c()) {
            com.unity3d.player.d.Log(5, "Native libraries not loaded - dropping message for " + string + "." + string2);
            return;
        }
        try {
            UnityPlayer.nativeUnitySendMessage(string, string2, string3.getBytes("UTF-8"));
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return;
        }
    }

    private static native void nativeUnitySendMessage(String var0, String var1, byte[] var2);

    private void finish() {
        if (this.mContext instanceof Activity && !((Activity)this.mContext).isFinishing()) {
            ((Activity)this.mContext).finish();
        }
    }

    void runOnAnonymousThread(Runnable runnable) {
        new Thread(runnable).start();
    }

    void runOnUiThread(Runnable runnable) {
        if (this.mContext instanceof Activity) {
            ((Activity)this.mContext).runOnUiThread(runnable);
            return;
        }
        com.unity3d.player.d.Log(5, "Not running Unity from an Activity; ignored...");
    }

    void postOnUiThread(Runnable runnable) {
        new Handler(Looper.getMainLooper()).post(runnable);
    }

    public void init(int n, boolean bl) {
    }

    public View getView() {
        return this;
    }

    public Bundle getSettings() {
        return Bundle.EMPTY;
    }

    public void quit() {
        this.destroy();
    }

    public void newIntent(Intent intent) {
        com.unity3d.player.d.Log(4, "onNewIntent");
        this.m_launchUri = intent.getData();
        this.m_MainThread.e();
    }

    public void destroy() {
        com.unity3d.player.d.Log(4, "onDestroy");
        if (this.m_Camera2Wrapper != null) {
            this.m_Camera2Wrapper.a();
            this.m_Camera2Wrapper = null;
        }
        if (this.m_HFPStatus != null) {
            this.m_HFPStatus.a();
            this.m_HFPStatus = null;
        }
        if (this.m_NetworkConnectivity != null) {
            this.m_NetworkConnectivity.b();
            this.m_NetworkConnectivity = null;
        }
        this.mQuitting = true;
        if (!this.mState.d()) {
            this.pause();
        }
        this.m_MainThread.a();
        try {
            this.m_MainThread.join(4000L);
        }
        catch (InterruptedException interruptedException) {
            this.m_MainThread.interrupt();
        }
        if (this.mKillingIsMyBusiness != null) {
            this.mContext.unregisterReceiver(this.mKillingIsMyBusiness);
        }
        this.mKillingIsMyBusiness = null;
        if (i.c()) {
            this.removeAllViews();
        }
        if (this.mProcessKillRequested) {
            this.m_UnityPlayerLifecycleEvents.onUnityPlayerQuitted();
            this.kill();
        }
        UnityPlayer.unloadNative();
    }

    protected void kill() {
        Process.killProcess((int)Process.myPid());
    }

    public void pause() {
        com.unity3d.player.d.Log(4, "onPause");
        if (this.m_ARCoreApi != null) {
            this.m_ARCoreApi.pauseARCore();
        }
        if (this.mVideoPlayerProxy != null) {
            this.mVideoPlayerProxy.a();
        }
        if (this.m_AudioVolumeHandler != null) {
            this.m_AudioVolumeHandler.a();
            this.m_AudioVolumeHandler = null;
        }
        this.pauseUnity();
    }

    private void pauseUnity() {
        this.reportSoftInputStr(null, 1, true);
        if (!this.mState.g()) {
            return;
        }
        if (i.c()) {
            final Semaphore semaphore = new Semaphore(0);
            Runnable runnable = this.isFinishing() ? new Runnable(){

                @Override
                public final void run() {
                    UnityPlayer.this.shutdown();
                    semaphore.release();
                }
            } : new Runnable(){

                @Override
                public final void run() {
                    if (UnityPlayer.this.nativePause()) {
                        UnityPlayer.this.mQuitting = true;
                        UnityPlayer.this.shutdown();
                        semaphore.release(2);
                        return;
                    }
                    semaphore.release();
                }
            };
            this.m_MainThread.a(runnable);
            try {
                if (!semaphore.tryAcquire(4L, TimeUnit.SECONDS)) {
                    com.unity3d.player.d.Log(5, "Timeout while trying to pause the Unity Engine.");
                }
            }
            catch (InterruptedException interruptedException) {
                com.unity3d.player.d.Log(5, "UI thread got interrupted while trying to pause the Unity Engine.");
            }
            if (semaphore.drainPermits() > 0) {
                this.destroy();
            }
        }
        this.mState.d(false);
        this.mState.b(true);
        if (this.m_AddPhoneCallListener) {
            this.m_TelephonyManager.listen((PhoneStateListener)this.m_PhoneCallListener, 0);
        }
    }

    public void resume() {
        com.unity3d.player.d.Log(4, "onResume");
        if (this.m_ARCoreApi != null) {
            this.m_ARCoreApi.resumeARCore();
        }
        this.mState.b(false);
        if (this.mVideoPlayerProxy != null) {
            this.mVideoPlayerProxy.b();
        }
        this.checkResumePlayer();
        if (i.c()) {
            this.nativeRestartActivityIndicator();
        }
        this.m_AudioVolumeHandler = new AudioVolumeHandler(this.mContext);
    }

    public void lowMemory() {
        if (!i.c()) {
            return;
        }
        this.queueGLThreadEvent(new Runnable(){

            @Override
            public final void run() {
                UnityPlayer.this.nativeLowMemory();
            }
        });
    }

    private void shutdown() {
        this.mProcessKillRequested = this.nativeDone();
        this.mState.c(false);
    }

    public void unload() {
        this.nativeApplicationUnload();
    }

    private void checkResumePlayer() {
        if (!this.mState.f()) {
            return;
        }
        this.mState.d(true);
        this.queueGLThreadEvent(new Runnable(){

            @Override
            public final void run() {
                UnityPlayer.this.nativeResume();
            }
        });
        this.m_MainThread.b();
    }

    protected boolean skipPermissionsDialog() {
        if (currentActivity != null) {
            return UnityPermissions.skipPermissionsDialog(currentActivity);
        }
        return false;
    }

    protected void requestUserAuthorization(String string) {
        if (string != null && !string.isEmpty() && currentActivity != null) {
            UnityPermissions.requestUserPermissions(currentActivity, new String[]{string}, null);
        }
    }

    protected int getNetworkConnectivity() {
        if (PlatformSupport.NOUGAT_SUPPORT) {
            if (this.m_NetworkConnectivity == null) {
                this.m_NetworkConnectivity = new NetworkConnectivity(this.mContext);
            }
            return this.m_NetworkConnectivity.a();
        }
        return 0;
    }

    public void configurationChanged(Configuration configuration) {
        com.unity3d.player.d.Log(4, "onConfigurationChanged");
        if (this.mGlView instanceof SurfaceView) {
            this.mGlView.getHolder().setSizeFromLayout();
        }
        if (this.mVideoPlayerProxy != null) {
            this.mVideoPlayerProxy.c();
        }
    }

    public void windowFocusChanged(boolean bl) {
        com.unity3d.player.d.Log(4, "windowFocusChanged: " + bl);
        this.mState.a(bl);
        if (!this.mState.e()) {
            return;
        }
        if (bl) {
            this.m_MainThread.c();
        } else {
            this.m_MainThread.d();
        }
        this.checkResumePlayer();
    }

    protected boolean loadLibrary(String string) {
        try {
            System.loadLibrary(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return false;
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    protected void addPhoneCallListener() {
        this.m_AddPhoneCallListener = true;
        this.m_TelephonyManager.listen((PhoneStateListener)this.m_PhoneCallListener, 32);
    }

    private final native void initJni(Context var1);

    private final native boolean nativeRender();

    private final native void nativeSetInputArea(int var1, int var2, int var3, int var4);

    private final native void nativeSetKeyboardIsVisible(boolean var1);

    private final native void nativeSetInputString(String var1);

    private final native void nativeSetInputSelection(int var1, int var2);

    private final native void nativeSoftInputCanceled();

    private final native void nativeSoftInputLostFocus();

    private final native void nativeReportKeyboardConfigChanged();

    private final native boolean nativePause();

    private final native void nativeResume();

    private final native void nativeLowMemory();

    private final native void nativeApplicationUnload();

    private final native void nativeFocusChanged(boolean var1);

    private final native void nativeRecreateGfxState(int var1, Surface var2);

    private final native void nativeSendSurfaceChangedEvent();

    private final native boolean nativeDone();

    private final native void nativeSoftInputClosed();

    private final native boolean nativeInjectEvent(InputEvent var1);

    private final native boolean nativeIsAutorotationOn();

    private final native void nativeMuteMasterAudio(boolean var1);

    private final native void nativeRestartActivityIndicator();

    private final native void nativeSetLaunchURL(String var1);

    private final native void nativeOrientationChanged(int var1, int var2);

    private static String logLoadLibMainError(String string, String string2) {
        string = "Failed to load 'libmain.so'\n\n" + string2;
        com.unity3d.player.d.Log(6, string);
        return string;
    }

    private static String loadNative(String string) {
        String string2 = string + "/libmain.so";
        try {
            System.load(string2);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return UnityPlayer.logLoadLibMainError(string2, unsatisfiedLinkError.toString());
        }
        catch (SecurityException securityException) {
            return UnityPlayer.logLoadLibMainError(string2, securityException.toString());
        }
        if (!NativeLoader.load(string)) {
            string = "NativeLoader.load failure, Unity libraries were not loaded.";
            com.unity3d.player.d.Log(6, string);
            return string;
        }
        i.a();
        return "";
    }

    private static void unloadNative() {
        if (!i.c()) {
            return;
        }
        if (!NativeLoader.unload()) {
            throw new UnsatisfiedLinkError("Unable to unload libraries from libmain.so");
        }
        i.b();
    }

    private static String getUnityNativeLibraryPath(Context context) {
        try {
            InputStream inputStream = context.getAssets().open("pram-shadow-files");
            return new Scanner(inputStream, "UTF-8").nextLine() + "/lib";
        }
        catch (IOException iOException) {
            return context.getApplicationInfo().nativeLibraryDir;
        }
    }

    protected void showSoftInput(final String string, final int n, final boolean bl, final boolean bl2, final boolean bl3, final boolean bl4, final String string2, final int n2, final boolean bl5) {
        final UnityPlayer unityPlayer = this;
        this.postOnUiThread(new Runnable(){

            @Override
            public final void run() {
                UnityPlayer.this.mSoftInputDialog = new com.unity3d.player.f(UnityPlayer.this.mContext, unityPlayer, string, n, bl, bl2, bl3, string2, n2, bl5);
                UnityPlayer.this.mSoftInputDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public final void onCancel(DialogInterface dialogInterface) {
                        UnityPlayer.this.nativeSoftInputLostFocus();
                        UnityPlayer.this.reportSoftInputStr(null, 1, false);
                    }
                });
                UnityPlayer.this.mSoftInputDialog.show();
                UnityPlayer.this.nativeReportKeyboardConfigChanged();
            }
        });
    }

    protected void hideSoftInput() {
        this.postOnUiThread(new Runnable(){

            @Override
            public final void run() {
                UnityPlayer.this.reportSoftInputArea(new Rect());
                UnityPlayer.this.reportSoftInputIsVisible(false);
                if (UnityPlayer.this.mSoftInputDialog != null) {
                    UnityPlayer.this.mSoftInputDialog.dismiss();
                    UnityPlayer.this.mSoftInputDialog = null;
                    UnityPlayer.this.nativeReportKeyboardConfigChanged();
                }
            }
        });
    }

    protected void setSoftInputStr(final String string) {
        this.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (UnityPlayer.this.mSoftInputDialog != null && string != null) {
                    UnityPlayer.this.mSoftInputDialog.a(string);
                }
            }
        });
    }

    protected void setCharacterLimit(final int n) {
        this.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (UnityPlayer.this.mSoftInputDialog != null) {
                    UnityPlayer.this.mSoftInputDialog.a(n);
                }
            }
        });
    }

    protected void setHideInputField(final boolean bl) {
        this.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (UnityPlayer.this.mSoftInputDialog != null) {
                    UnityPlayer.this.mSoftInputDialog.a(bl);
                }
            }
        });
    }

    protected void setSelection(final int n, final int n2) {
        this.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                if (UnityPlayer.this.mSoftInputDialog != null) {
                    UnityPlayer.this.mSoftInputDialog.a(n, n2);
                }
            }
        });
    }

    protected String getKeyboardLayout() {
        if (this.mSoftInputDialog == null) {
            return null;
        }
        return this.mSoftInputDialog.a();
    }

    protected void reportSoftInputStr(final String string, final int n, final boolean bl) {
        if (n == 1) {
            this.hideSoftInput();
        }
        this.queueGLThreadEvent(new f(){

            @Override
            public final void a() {
                if (bl) {
                    UnityPlayer.this.nativeSoftInputCanceled();
                } else if (string != null) {
                    UnityPlayer.this.nativeSetInputString(string);
                }
                if (n == 1) {
                    UnityPlayer.this.nativeSoftInputClosed();
                }
            }
        });
    }

    protected void reportSoftInputSelection(final int n, final int n2) {
        this.queueGLThreadEvent(new f(){

            @Override
            public final void a() {
                UnityPlayer.this.nativeSetInputSelection(n, n2);
            }
        });
    }

    protected void reportSoftInputArea(final Rect rect) {
        this.queueGLThreadEvent(new f(){

            @Override
            public final void a() {
                UnityPlayer.this.nativeSetInputArea(rect.left, rect.top, rect.right, rect.bottom);
            }
        });
    }

    protected void reportSoftInputIsVisible(final boolean bl) {
        this.queueGLThreadEvent(new f(){

            @Override
            public final void a() {
                UnityPlayer.this.nativeSetKeyboardIsVisible(bl);
            }
        });
    }

    protected void setClipboardText(String string) {
        string = ClipData.newPlainText((CharSequence)"Text", (CharSequence)string);
        this.m_ClipboardManager.setPrimaryClip((ClipData)string);
    }

    protected String getClipboardText() {
        String string = "";
        ClipData clipData = this.m_ClipboardManager.getPrimaryClip();
        if (clipData != null) {
            string = clipData.getItemAt(0).coerceToText(this.mContext).toString();
        }
        return string;
    }

    protected String getLaunchURL() {
        if (this.m_launchUri != null) {
            return this.m_launchUri.toString();
        }
        return null;
    }

    protected boolean initializeGoogleAr() {
        if (this.m_ARCoreApi == null && currentActivity != null && this.getARCoreEnabled()) {
            this.m_ARCoreApi = new GoogleARCoreApi();
            this.m_ARCoreApi.initializeARCore(currentActivity);
            if (!this.mState.d()) {
                this.m_ARCoreApi.resumeARCore();
            }
        }
        return false;
    }

    protected boolean showVideoPlayer(String string, int n, int n2, int n3, boolean bl, int n4, int n5) {
        boolean bl2;
        if (this.mVideoPlayerProxy == null) {
            this.mVideoPlayerProxy = new k(this);
        }
        if (bl2 = this.mVideoPlayerProxy.a(this.mContext, string, n, n2, n3, bl, n4, n5, new k.a(){

            @Override
            public final void a() {
                UnityPlayer.this.mVideoPlayerProxy = null;
            }
        })) {
            this.runOnUiThread(new Runnable(){

                @Override
                public final void run() {
                    if (UnityPlayer.this.nativeIsAutorotationOn() && UnityPlayer.this.mContext instanceof Activity) {
                        ((Activity)UnityPlayer.this.mContext).setRequestedOrientation(UnityPlayer.this.mInitialScreenOrientation);
                    }
                }
            });
        }
        return bl2;
    }

    protected void pauseJavaAndCallUnloadCallback() {
        this.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                UnityPlayer.this.pause();
                UnityPlayer.this.windowFocusChanged(false);
                UnityPlayer.this.m_UnityPlayerLifecycleEvents.onUnityPlayerUnloaded();
            }
        });
    }

    private ApplicationInfo getApplicationInfo() {
        return this.mContext.getPackageManager().getApplicationInfo(this.mContext.getPackageName(), 128);
    }

    private boolean getSplashEnabled() {
        try {
            return this.getApplicationInfo().metaData.getBoolean(SPLASH_ENABLE_METADATA_NAME);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean getARCoreEnabled() {
        try {
            return this.getApplicationInfo().metaData.getBoolean(ARCORE_ENABLE_METADATA_NAME);
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected int getSplashMode() {
        try {
            return this.getApplicationInfo().metaData.getInt(SPLASH_MODE_METADATA_NAME);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    protected void executeGLThreadJobs() {
        Runnable runnable;
        while ((runnable = (Runnable)this.m_Events.poll()) != null) {
            runnable.run();
        }
    }

    protected void disableLogger() {
        com.unity3d.player.d.a = true;
    }

    private void queueGLThreadEvent(Runnable runnable) {
        if (!i.c()) {
            return;
        }
        if (Thread.currentThread() == this.m_MainThread) {
            runnable.run();
            return;
        }
        this.m_Events.add(runnable);
    }

    private void queueGLThreadEvent(f f2) {
        if (this.isFinishing()) {
            return;
        }
        this.queueGLThreadEvent((Runnable)f2);
    }

    protected boolean isFinishing() {
        return this.mQuitting || (this.mQuitting = this.mContext instanceof Activity && ((Activity)this.mContext).isFinishing());
    }

    private void hideStatusBar() {
        if (this.mContext instanceof Activity) {
            ((Activity)this.mContext).getWindow().setFlags(1024, 1024);
        }
    }

    public boolean injectEvent(InputEvent inputEvent) {
        if (!i.c()) {
            return false;
        }
        return this.nativeInjectEvent(inputEvent);
    }

    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        return this.injectEvent((InputEvent)keyEvent);
    }

    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        return this.injectEvent((InputEvent)keyEvent);
    }

    public boolean onKeyMultiple(int n, int n2, KeyEvent keyEvent) {
        return this.injectEvent((InputEvent)keyEvent);
    }

    public boolean onKeyLongPress(int n, KeyEvent keyEvent) {
        return this.injectEvent((InputEvent)keyEvent);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        return this.injectEvent((InputEvent)motionEvent);
    }

    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        return this.injectEvent((InputEvent)motionEvent);
    }

    private void swapViews(View view, View view2) {
        ViewParent viewParent;
        boolean bl = false;
        if (!this.mState.d()) {
            this.pause();
            bl = true;
        }
        if (!(view == null || (viewParent = view.getParent()) instanceof UnityPlayer && (UnityPlayer)viewParent == this)) {
            if (viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(view);
            }
            this.addView(view);
            this.bringChildToFront(view);
            view.setVisibility(0);
        }
        if (view2 != null && view2.getParent() == this) {
            view2.setVisibility(8);
            this.removeView(view2);
        }
        if (bl) {
            this.resume();
        }
    }

    public boolean addViewToPlayer(View view, boolean bl) {
        this.swapViews(view, (View)(bl ? this.mGlView : null));
        boolean bl2 = view.getParent() == this;
        bl = bl && this.mGlView.getParent() == null;
        boolean bl3 = this.mGlView.getParent() == this;
        boolean bl4 = bl2 && (bl || bl3);
        if (!bl4) {
            if (!bl2) {
                com.unity3d.player.d.Log(6, "addViewToPlayer: Failure adding view to hierarchy");
            }
            if (!bl && !bl3) {
                com.unity3d.player.d.Log(6, "addViewToPlayer: Failure removing old view from hierarchy");
            }
        }
        return bl4;
    }

    public void removeViewFromPlayer(View view) {
        this.swapViews((View)this.mGlView, view);
        boolean bl = view.getParent() == null;
        boolean bl2 = this.mGlView.getParent() == this;
        if (!(bl && bl2)) {
            if (!bl) {
                com.unity3d.player.d.Log(6, "removeViewFromPlayer: Failure removing view from hierarchy");
            }
            if (!bl2) {
                com.unity3d.player.d.Log(6, "removeVireFromPlayer: Failure agging old view to hierarchy");
            }
        }
    }

    public void reportError(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(string2);
        com.unity3d.player.d.Log(6, stringBuilder.toString());
    }

    public String getNetworkProxySettings(String charSequence) {
        String string;
        String string2;
        if (((String)charSequence).startsWith("http:")) {
            charSequence = "http.proxyHost";
            string2 = "http.proxyPort";
            string = "http.nonProxyHosts";
        } else if (((String)charSequence).startsWith("https:")) {
            charSequence = "https.proxyHost";
            string2 = "https.proxyPort";
            string = "http.nonProxyHosts";
        } else {
            return null;
        }
        charSequence = System.getProperties().getProperty((String)charSequence);
        if (charSequence == null || "".equals(charSequence)) {
            return null;
        }
        charSequence = new StringBuilder((String)charSequence);
        string2 = System.getProperties().getProperty(string2);
        if (string2 != null && !"".equals(string2)) {
            ((StringBuilder)charSequence).append(":").append(string2);
        }
        if ((string2 = System.getProperties().getProperty(string)) != null && !"".equals(string2)) {
            ((StringBuilder)charSequence).append('\n').append(string2);
        }
        return ((StringBuilder)charSequence).toString();
    }

    public boolean startOrientationListener(int n) {
        if (this.mOrientationListener != null) {
            com.unity3d.player.d.Log(5, "Orientation Listener already started.");
            return false;
        }
        this.mOrientationListener = new OrientationEventListener(this.mContext, n){

            public final void onOrientationChanged(int n) {
                UnityPlayer.this.m_MainThread.a(UnityPlayer.this.mNaturalOrientation, n);
            }
        };
        if (this.mOrientationListener.canDetectOrientation()) {
            this.mOrientationListener.enable();
            return true;
        }
        com.unity3d.player.d.Log(5, "Orientation Listener cannot detect orientation.");
        return false;
    }

    public boolean stopOrientationListener() {
        if (this.mOrientationListener == null) {
            com.unity3d.player.d.Log(5, "Orientation Listener was not started.");
            return false;
        }
        this.mOrientationListener.disable();
        this.mOrientationListener = null;
        return true;
    }

    static {
        new h().a();
    }

    private abstract class f
    implements Runnable {
        private f() {
        }

        @Override
        public final void run() {
            if (!UnityPlayer.this.isFinishing()) {
                this.a();
            }
        }

        public abstract void a();

        /* synthetic */ f(byte by) {
            this();
        }
    }

    final class a
    implements SensorEventListener {
        a() {
        }

        public final void onAccuracyChanged(Sensor sensor, int n) {
        }

        public final void onSensorChanged(SensorEvent sensorEvent) {
        }
    }

    private final class c
    extends PhoneStateListener {
        private c() {
        }

        public final void onCallStateChanged(int n, String string) {
            UnityPlayer.this.nativeMuteMasterAudio(n == 1);
        }

        /* synthetic */ c(byte by) {
            this();
        }
    }

    private final class e
    extends Thread {
        Handler a;
        boolean b = false;
        boolean c = false;
        int d = com.unity3d.player.UnityPlayer$b.b;
        int e = 0;
        int f;
        int g;
        int h = 5;

        private e() {
        }

        @Override
        public final void run() {
            this.setName("UnityMain");
            Looper.prepare();
            this.a = new Handler(new Handler.Callback(){

                private void a() {
                    if (e.this.d == com.unity3d.player.UnityPlayer$b.c && e.this.c) {
                        UnityPlayer.this.nativeFocusChanged(true);
                        e.this.d = com.unity3d.player.UnityPlayer$b.a;
                    }
                }

                public final boolean handleMessage(Message object) {
                    if (object.what != 2269) {
                        return false;
                    }
                    object = (d)((Object)object.obj);
                    if (object == com.unity3d.player.UnityPlayer$d.h) {
                        --e.this.e;
                        UnityPlayer.this.executeGLThreadJobs();
                        if (!e.this.b) {
                            return true;
                        }
                        if (!e.this.c) {
                            return true;
                        }
                        if (e.this.h >= 0) {
                            if (e.this.h == 0 && UnityPlayer.this.getSplashEnabled()) {
                                UnityPlayer.this.DisableStaticSplashScreen();
                            }
                            --e.this.h;
                        }
                        if (!UnityPlayer.this.isFinishing() && !UnityPlayer.this.nativeRender()) {
                            UnityPlayer.this.finish();
                        }
                    } else if (object == com.unity3d.player.UnityPlayer$d.c) {
                        Looper.myLooper().quit();
                    } else if (object == com.unity3d.player.UnityPlayer$d.b) {
                        e.this.b = true;
                    } else if (object == com.unity3d.player.UnityPlayer$d.a) {
                        e.this.b = false;
                    } else if (object == com.unity3d.player.UnityPlayer$d.d) {
                        e.this.c = false;
                    } else if (object == com.unity3d.player.UnityPlayer$d.e) {
                        e.this.c = true;
                        this.a();
                    } else if (object == com.unity3d.player.UnityPlayer$d.f) {
                        if (e.this.d == com.unity3d.player.UnityPlayer$b.a) {
                            UnityPlayer.this.nativeFocusChanged(false);
                        }
                        e.this.d = com.unity3d.player.UnityPlayer$b.b;
                    } else if (object == com.unity3d.player.UnityPlayer$d.g) {
                        e.this.d = com.unity3d.player.UnityPlayer$b.c;
                        this.a();
                    } else if (object == com.unity3d.player.UnityPlayer$d.i) {
                        UnityPlayer.this.nativeSetLaunchURL(UnityPlayer.this.getLaunchURL());
                    } else if (object == com.unity3d.player.UnityPlayer$d.j) {
                        UnityPlayer.this.nativeOrientationChanged(e.this.f, e.this.g);
                    }
                    if (e.this.b && e.this.e <= 0) {
                        Message.obtain((Handler)e.this.a, (int)2269, (Object)((Object)com.unity3d.player.UnityPlayer$d.h)).sendToTarget();
                        ++e.this.e;
                    }
                    return true;
                }
            });
            Looper.loop();
        }

        public final void a() {
            this.a(com.unity3d.player.UnityPlayer$d.c);
        }

        public final void b() {
            this.a(com.unity3d.player.UnityPlayer$d.b);
        }

        public final void a(Runnable runnable) {
            if (this.a == null) {
                return;
            }
            this.a(com.unity3d.player.UnityPlayer$d.a);
            Message.obtain((Handler)this.a, (Runnable)runnable).sendToTarget();
        }

        public final void c() {
            this.a(com.unity3d.player.UnityPlayer$d.g);
        }

        public final void d() {
            this.a(com.unity3d.player.UnityPlayer$d.f);
        }

        public final void b(Runnable runnable) {
            if (this.a == null) {
                return;
            }
            this.a(com.unity3d.player.UnityPlayer$d.d);
            Message.obtain((Handler)this.a, (Runnable)runnable).sendToTarget();
        }

        public final void c(Runnable runnable) {
            if (this.a == null) {
                return;
            }
            Message.obtain((Handler)this.a, (Runnable)runnable).sendToTarget();
            this.a(com.unity3d.player.UnityPlayer$d.e);
        }

        public final void d(Runnable runnable) {
            if (this.a != null) {
                Message.obtain((Handler)this.a, (Runnable)runnable).sendToTarget();
            }
        }

        public final void e() {
            this.a(com.unity3d.player.UnityPlayer$d.i);
        }

        private void a(d d2) {
            if (this.a != null) {
                Message.obtain((Handler)this.a, (int)2269, (Object)((Object)d2)).sendToTarget();
            }
        }

        public final void a(int n, int n2) {
            this.f = n;
            this.g = n2;
            this.a(com.unity3d.player.UnityPlayer$d.j);
        }

        /* synthetic */ e(byte by) {
            this();
        }
    }

    static final class b
    extends Enum {
        public static final /* enum */ int a = 1;
        public static final /* enum */ int b = 2;
        public static final /* enum */ int c = 3;
        private static final /* synthetic */ int[] d;

        static {
            d = new int[]{a, b, c};
        }
    }

    static final class d
    extends Enum {
        public static final /* enum */ d a = new d("PAUSE", 0);
        public static final /* enum */ d b = new d("RESUME", 1);
        public static final /* enum */ d c = new d("QUIT", 2);
        public static final /* enum */ d d = new d("SURFACE_LOST", 3);
        public static final /* enum */ d e = new d("SURFACE_ACQUIRED", 4);
        public static final /* enum */ d f = new d("FOCUS_LOST", 5);
        public static final /* enum */ d g = new d("FOCUS_GAINED", 6);
        public static final /* enum */ d h = new d("NEXT_FRAME", 7);
        public static final /* enum */ d i = new d("URL_ACTIVATED", 8);
        public static final /* enum */ d j = new d("ORIENTATION_ANGLE_CHANGE", 9);
        private static final /* synthetic */ d[] k;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private d() {
            void var2_-1;
            void var1_-1;
        }

        static {
            k = new d[]{a, b, c, d, e, f, g, h, i, j};
        }
    }
}

