using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class SkeletonScript : MonoBehaviour
{

    [SerializeField] float speed = 2f;
    Vector2 startPos;
    bool lookRight = true;
    SpriteRenderer sp;

    void Start()
    {
        startPos = transform.position;
        sp = GetComponent<SpriteRenderer>();
    }

    void Update()
    {
        transform.Translate(Vector3.right * Time.deltaTime * speed);

        if (Vector2.Distance(transform.position, startPos) < 0.5f && !lookRight)
            FlipCharacter();
    }

    private void OnTriggerEnter2D(Collider2D collision)
    {
        if (collision.tag == "PointRetour")
        {
            FlipCharacter();
        }
    }

    void FlipCharacter()
    {
        sp.flipX = !sp.flipX;
        speed = -speed;
        lookRight = !lookRight;
    }
}
