using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.SceneManagement;

public class EndPointScript : MonoBehaviour
{

    [SerializeField] GameObject particle;
    AudioSource audios;

    private void Start()
    {
        audios = GetComponent<AudioSource>();
    }
    private void OnTriggerEnter2D(Collider2D collision)
    {
        if (collision.CompareTag("Player"))
        {
            collision.GetComponent<KingController>().enabled = false;
            collision.GetComponent<Animator>().SetTrigger("Win");
            GameObject.Find("Music Background").GetComponent<AudioSource>().enabled = false;
            audios.Play();
            particle.SetActive(true);
            StartCoroutine(WaitForEndOfMusic());
        }
    }

  IEnumerator WaitForEndOfMusic()
  {
     PlayerPrefs.SetInt("LastLevel", SceneManager.GetActiveScene().buildIndex);
     yield return new WaitForSeconds(audios.clip.length);
     SceneManager.LoadScene(SceneManager.GetActiveScene().buildIndex + 1);
  }
}
