﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class MuteSound : MonoBehaviour {

    AudioSource[] sources;

    private void Awake()
    {
        sources = FindObjectsOfType(typeof(AudioSource)) as AudioSource[];

        if(PlayerPrefs.GetInt("mute")==0)
        {
            Mute(true);
        }
        else
        {
            Mute(false);
        }
    }

    void Mute(bool val)
    {
        foreach( AudioSource asource in sources)
        {
            GetComponent<AudioSource>().enabled = val ? false : true;
        }
    }
}
