using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class KingController : MonoBehaviour
{
    [SerializeField] float speed = 2f, jumpForce = 500f;
    Rigidbody2D rb;
    Animator anim;
    bool lookRight = true;
    public bool OnAttack = false;
    public static bool gameIsPaused = false;

    [SerializeField] GameObject particleHeal;
    [SerializeField] GameObject particleHeart;
    [SerializeField] GameObject particleHurt;
    [SerializeField] GameObject particleDeathEnnemy;



    float dmg = 0.5f;
    //grounded
    [SerializeField] bool grounded;
    [SerializeField] float groundRadius = 0.02f;
    [SerializeField] Transform groundCheck;
    [SerializeField] LayerMask theGround;

    [SerializeField] AudioClip sndAttack, sndAttack2, sndJump, sndHurt, sndDead, sndWin, sndSkeleton, sndSArcher, sndPickup, sndCoinGold, sndAddHealth;
    AudioSource audioS;

    [SerializeField] GameObject CanvasGameOver ;
    [SerializeField] GameObject CanvaspauseMenu;


    void Awake()
    {
        rb = GetComponent<Rigidbody2D>();
        anim = GetComponent<Animator>();
        audioS = GetComponent<AudioSource>();

        if (PlayerPrefs.GetInt("mute") == 0)
            {
                GetComponent<AudioSource>().enabled = false;
            }
    }

    // Update is called once per frame
    void Update()
    {
        grounded = Physics2D.OverlapCircle(groundCheck.position, groundRadius, theGround);
        anim.SetBool("Grounded", grounded);

        float move = Input.GetAxis("Horizontal");
        transform.Translate(Vector2.right * move * speed * Time.deltaTime);
        anim.SetFloat("Speed", Mathf.Abs(move));
        anim.SetFloat("Vspeed", rb.velocity.y);

        if (move > 0 && !lookRight)
        {
            Flip();
        }
        else if (move < 0 && lookRight)
        {
            Flip();
        }

        if (Input.GetKeyDown(KeyCode.Mouse0) && grounded && !OnAttack)
        {
            OnAttack = true;
            anim.SetTrigger("Attack");
            audioS.PlayOneShot(sndAttack);

        }
        if (Input.GetKeyDown(KeyCode.Mouse1) && grounded && !OnAttack)
        {
            OnAttack = true;
            anim.SetTrigger("Attack2");
            audioS.PlayOneShot(sndAttack2);
        }

        if (Input.GetKeyDown(KeyCode.Escape))
        {
            if (gameIsPaused)
            {
                Resume();
            }
            else
            {
                Paused();
            }
        }

        ///Debug
        if (Input.GetKeyDown(KeyCode.F1)) Hurt();
        if (Input.GetKeyDown(KeyCode.F2)) Win();
        if (Input.GetKeyDown(KeyCode.F3)) Dead();
    }

    private void FixedUpdate()
    {
        if (Input.GetKey(KeyCode.Space) && grounded)
        {
            rb.AddForce(new Vector2(0, jumpForce),ForceMode2D.Impulse);
            audioS.PlayOneShot(sndJump);
        }
    }

    void Flip()
    {
        lookRight = !lookRight;
        Vector2 theScale = transform.localScale;
        theScale.x *= -1;
        transform.localScale = theScale;
    }

    public void Hurt()
    {
        anim.SetTrigger("Hurt");
        audioS.PlayOneShot(sndHurt);
        GameObject HurtParticle = Instantiate(particleHurt, transform.position, Quaternion.identity);
        PlayerStats.Instance.TakeDamage(dmg);
        if (PlayerStats.Instance.Health <= 0) CanvasGameOver.SetActive(true);
    }

    public void Win()
    {
        anim.SetTrigger("Win");
        audioS.PlayOneShot(sndWin);
    }

    public void Dead()
    {
        anim.SetTrigger("Dead");
        audioS.PlayOneShot(sndDead);
    }

    private void OnCollisionEnter2D(Collision2D collision)
    {
        if (collision.gameObject.CompareTag("Ennemy"))
        {
            if (OnAttack)
            {
                Animator animSkeleton = collision.gameObject.GetComponent<Animator>();

                audioS.PlayOneShot(sndSkeleton);

                animSkeleton.SetTrigger("dead_skeleton");
                collision.gameObject.GetComponent<CapsuleCollider2D>().enabled = false;
                GameObject DeathEnnemyParticle = Instantiate(particleDeathEnnemy, transform.position, Quaternion.identity);
                Destroy(collision.transform.parent.gameObject, 0.5f);

            }
            else
            {
                Vector2 move = collision.transform.position - transform.position;
                rb.AddForce(move.normalized * -400);
                Hurt();
            }
        }
        else if (collision.gameObject.CompareTag("Archer"))
        {
            if (OnAttack)
            {
                Animator animArcher = collision.gameObject.GetComponent<Animator>();
                audioS.PlayOneShot(sndSArcher);
                animArcher.SetTrigger("dead_archer");
                collision.gameObject.GetComponent<BoxCollider2D>().enabled = false;
                Destroy(collision.transform.parent.gameObject, 0.8f);
            }
            else
            {
                Vector2 move = collision.transform.position - transform.position;
                rb.AddForce(move.normalized * -400);
                Hurt();
            }
        }
    }

    public void AttackBool()
    {
        OnAttack = false;
    }

    private void OnTriggerEnter2D(Collider2D collision)
    {
        if(collision.CompareTag("DeadZone"))
        {
            CanvasGameOver.SetActive(true);
        }

        else if (collision.CompareTag("Heal"))
        {
            PlayerStats.Instance.Heal(collision.gameObject.GetComponent<HealScript>().Heal);
            Destroy(collision.gameObject);
            GameObject HealParticle = Instantiate(particleHeal, transform.position, Quaternion.identity);
            audioS.PlayOneShot(sndPickup);
        }

        else if(collision.CompareTag("Heart"))
        {
            PlayerStats.Instance.AddHealth();
            Destroy(collision.gameObject);
            GameObject HeartParticle = Instantiate(particleHeart, transform.position, Quaternion.identity);
            audioS.PlayOneShot(sndAddHealth);
        }
        else if(collision.CompareTag("Gold"))
        {
            Inventory.instance.AddCoins(1);
            Destroy(collision.gameObject);
            audioS.PlayOneShot(sndCoinGold);
        }
    }

    void Paused()
    {
        CanvaspauseMenu.SetActive(true);
        Time.timeScale = 0;
        gameIsPaused = true;
        GameObject.Find("Music Background").GetComponent<AudioSource>().mute = true;
        OnAttack = true;
    }

    public void Resume()
    {

        CanvaspauseMenu.SetActive(false);
        Time.timeScale = 1;
        gameIsPaused = false;
        GameObject.Find("Music Background").GetComponent<AudioSource>().mute = false;
        OnAttack = false;
    }
}
