﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.SceneManagement;
using UnityEngine.UI;

public class MenuUI : MonoBehaviour
{
    Image iMute;
    [SerializeField] Sprite spMute, spSound;
    bool isPlaying = true;

    [SerializeField] private GameObject MenuObject;
    [SerializeField] private GameObject LevelObject;
    
    bool MenuBool = true;

    
    // Start is called before the first frame update
    private void Start()
    {
        iMute = GameObject.Find("ImMute").GetComponent<Image>();
        bool mute = PlayerPrefs.GetInt("mute") == 0 ? false : true;
        bool mutet = PlayerPrefs.GetInt("mute") == 0 ? GetComponent<AudioSource>().enabled = false : GetComponent<AudioSource>().enabled = true; 
        iMute.sprite = mute ? spMute : spSound;
    }

    private void Awake()
    {

    }

    // Update is called once per frame
    void Update()
    {
        
    }
    // Début du jeu, lance la 1er scéne
    public void StartGame()
    {
        SceneManager.LoadScene(1);
    }

    public void Continue()
    {
        SceneManager.LoadScene(PlayerPrefs.GetInt("LastLevel") + 1);
    }

    //Tansition entre le menu accuil et la sélection de levels
    public void SelectLevel()
    {
        if (MenuBool)
        {
            MenuObject.SetActive(false);
            LevelObject.SetActive(true);
            MenuBool = false;
        } else if (!MenuBool)
        {
            MenuObject.SetActive(true);
            LevelObject.SetActive(false);
            MenuBool = true;
        }
    }
    //Charge la scéne "Crédits"
    public void LoadCreditsScene()
    {
        Time.timeScale = 1;
        SceneManager.LoadScene("Credits");
    }

    //Quitte le jeu
    public void QuitGame()
    {
#if UNITY_EDITOR
        UnityEditor.EditorApplication.isPlaying = false;
#else
        Application.Quit();
#endif
    }

    // charge le level choisi
    public void LoadLevel(int level)
    {
        SceneManager.LoadScene(level);
    }

    public void MuteSound ()
    {
        isPlaying = !isPlaying;
        iMute.sprite = isPlaying ? spMute : spSound;
        PlayerPrefs.SetInt("mute", isPlaying ? 1 : 0);

        if (PlayerPrefs.GetInt("mute") == 0)
        {
            GetComponent<AudioSource>().enabled = false;
        }
        else if (PlayerPrefs.GetInt("mute") == 1 )
        {
            GetComponent<AudioSource>().enabled = true;
        }
    }
}
