using UnityEngine;
using UnityEngine.SceneManagement;

public class PauseMenu : MonoBehaviour
{
    [SerializeField] string[] tags;

    void Start()
    {

        foreach (string tag in tags)
        {
            GameObject[] go = GameObject.FindGameObjectsWithTag(tag);

            foreach (GameObject g in go)
            {
                g.SetActive(false);
            }
        }
    }
    
    private void Awake()
    {
        if (PlayerPrefs.GetInt("mute") == 0)
        {
            GetComponent<AudioSource>().enabled = false;
        }

    }

    public void LoadMenu()
    {
        SceneManager.LoadScene("Menu");
    }
}
